/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.layout;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.sf.jabref.logic.layout.Layout;
import net.sf.jabref.logic.layout.LayoutFormatterPreferences;
import net.sf.jabref.logic.layout.StringInt;

public class LayoutHelper {
    public static final int IS_LAYOUT_TEXT = 1;
    public static final int IS_SIMPLE_FIELD = 2;
    public static final int IS_FIELD_START = 3;
    public static final int IS_FIELD_END = 4;
    public static final int IS_OPTION_FIELD = 5;
    public static final int IS_GROUP_START = 6;
    public static final int IS_GROUP_END = 7;
    public static final int IS_ENCODING_NAME = 8;
    public static final int IS_FILENAME = 9;
    public static final int IS_FILEPATH = 10;
    private static String currentGroup;
    private final PushbackReader in;
    private final List<StringInt> parsedEntries = new ArrayList<StringInt>();
    private final LayoutFormatterPreferences prefs;
    private boolean endOfFile;

    public LayoutHelper(Reader in, LayoutFormatterPreferences prefs) {
        this.in = new PushbackReader(Objects.requireNonNull(in));
        this.prefs = Objects.requireNonNull(prefs);
    }

    public Layout getLayoutFromText() throws IOException {
        this.parse();
        for (StringInt parsedEntry : this.parsedEntries) {
            if (parsedEntry.i != 2 && parsedEntry.i != 3 && parsedEntry.i != 4 && parsedEntry.i != 6 && parsedEntry.i != 7) continue;
            parsedEntry.s = parsedEntry.s.trim().toLowerCase();
        }
        return new Layout(this.parsedEntries, this.prefs);
    }

    public static String getCurrentGroup() {
        return currentGroup;
    }

    public static void setCurrentGroup(String newGroup) {
        currentGroup = newGroup;
    }

    private void doBracketedField(int field) throws IOException {
        StringBuilder buffer = null;
        boolean start = false;
        while (!this.endOfFile) {
            int c = this.read();
            if (c == -1) {
                this.endOfFile = true;
                if (buffer != null) {
                    this.parsedEntries.add(new StringInt(buffer.toString(), field));
                }
                return;
            }
            if (c == 123 || c == 125) {
                if (c == 125) {
                    if (buffer == null) continue;
                    this.parsedEntries.add(new StringInt(buffer.toString(), field));
                    return;
                }
                start = true;
                continue;
            }
            if (buffer == null) {
                buffer = new StringBuilder(100);
            }
            if (!start || c == 125) continue;
            buffer.append((char)c);
        }
    }

    private void doBracketedOptionField() throws IOException {
        StringBuilder buffer = null;
        boolean start = false;
        boolean inQuotes = false;
        boolean doneWithOptions = false;
        String option = null;
        while (!this.endOfFile) {
            int c = this.read();
            if (c == -1) {
                this.endOfFile = true;
                if (buffer != null) {
                    String tmp = option == null ? buffer.toString() : buffer.toString() + '\n' + option;
                    this.parsedEntries.add(new StringInt(tmp, 5));
                }
                return;
            }
            if (!inQuotes && (c == 93 || c == 91 || doneWithOptions && (c == 123 || c == 125))) {
                if (c == 93 || doneWithOptions && c == 125) {
                    if (c == 93 && buffer != null) {
                        option = buffer.toString();
                        buffer = null;
                        start = false;
                        doneWithOptions = true;
                        continue;
                    }
                    if (c != 125) continue;
                    String parameter = buffer == null ? " " : buffer.toString();
                    String tmp = option == null ? parameter : parameter + '\n' + option;
                    this.parsedEntries.add(new StringInt(tmp, 5));
                    return;
                }
                start = true;
                continue;
            }
            if (c == 34) {
                boolean bl = inQuotes = !inQuotes;
                if (buffer == null) {
                    buffer = new StringBuilder(100);
                }
                buffer.append('\"');
                continue;
            }
            if (buffer == null) {
                buffer = new StringBuilder(100);
            }
            if (!start) continue;
            buffer.append((char)c);
        }
    }

    private void parse() throws IOException, StringIndexOutOfBoundsException {
        this.skipWhitespace();
        StringBuilder buffer = null;
        boolean escaped = false;
        while (!this.endOfFile) {
            int c = this.read();
            if (c == -1) {
                this.endOfFile = true;
                if (buffer != null) {
                    this.parsedEntries.add(new StringInt(buffer.toString(), 1));
                }
                return;
            }
            if (c == 92 && this.peek() != 92 && !escaped) {
                if (buffer != null) {
                    this.parsedEntries.add(new StringInt(buffer.toString(), 1));
                    buffer = null;
                }
                this.parseField();
                escaped = false;
                continue;
            }
            if (buffer == null) {
                buffer = new StringBuilder(100);
            }
            if (c != 92 || escaped) {
                buffer.append((char)c);
            }
            escaped = c == 92 && !escaped;
        }
    }

    private void parseField() throws IOException {
        StringBuilder buffer = null;
        while (!this.endOfFile) {
            int c = this.read();
            if (c == -1) {
                this.endOfFile = true;
            }
            if (!Character.isLetter((char)c) && c != 95 && c != 45) {
                String name;
                this.unread(c);
                String string = name = buffer == null ? "" : buffer.toString();
                if (name.isEmpty()) {
                    StringBuilder lastFive = new StringBuilder(10);
                    for (StringInt entry : this.parsedEntries.subList(Math.max(0, this.parsedEntries.size() - 6), this.parsedEntries.size() - 1)) {
                        lastFive.append(entry.s);
                    }
                    throw new StringIndexOutOfBoundsException("Backslash parsing error near '" + lastFive.toString().replace("\n", " ") + '\'');
                }
                if ("begin".equalsIgnoreCase(name)) {
                    this.doBracketedField(3);
                    return;
                }
                if ("begingroup".equalsIgnoreCase(name)) {
                    this.doBracketedField(6);
                    return;
                }
                if ("format".equalsIgnoreCase(name)) {
                    if (c == 91) {
                        this.doBracketedOptionField();
                        return;
                    }
                    this.doBracketedField(5);
                    return;
                }
                if ("filename".equalsIgnoreCase(name)) {
                    this.parsedEntries.add(new StringInt(name, 9));
                    return;
                }
                if ("filepath".equalsIgnoreCase(name)) {
                    this.parsedEntries.add(new StringInt(name, 10));
                    return;
                }
                if ("end".equalsIgnoreCase(name)) {
                    this.doBracketedField(4);
                    return;
                }
                if ("endgroup".equalsIgnoreCase(name)) {
                    this.doBracketedField(7);
                    return;
                }
                if ("encoding".equalsIgnoreCase(name)) {
                    this.parsedEntries.add(new StringInt(name, 8));
                    return;
                }
                this.parsedEntries.add(new StringInt(name, 2));
                return;
            }
            if (buffer == null) {
                buffer = new StringBuilder(100);
            }
            buffer.append((char)c);
        }
    }

    private int peek() throws IOException {
        int c = this.read();
        this.unread(c);
        return c;
    }

    private int read() throws IOException {
        return this.in.read();
    }

    private void skipWhitespace() throws IOException {
        int c;
        do {
            if ((c = this.read()) != -1 && c != 65535) continue;
            this.endOfFile = true;
            return;
        } while (Character.isWhitespace((char)c));
        this.unread(c);
    }

    private void unread(int c) throws IOException {
        this.in.unread(c);
    }
}

