/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.layout;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import net.sf.jabref.logic.layout.LayoutEntry;
import net.sf.jabref.logic.layout.LayoutFormatter;
import net.sf.jabref.logic.layout.LayoutFormatterPreferences;
import net.sf.jabref.logic.layout.StringInt;
import net.sf.jabref.model.database.BibDatabase;
import net.sf.jabref.model.database.BibDatabaseContext;
import net.sf.jabref.model.entry.BibEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Layout {
    private final List<LayoutEntry> layoutEntries;
    private final List<String> missingFormatters = new ArrayList<String>();
    private static final Log LOGGER = LogFactory.getLog(Layout.class);

    public Layout(List<StringInt> parsedEntries, LayoutFormatterPreferences prefs) {
        ArrayList<LayoutEntry> tmpEntries = new ArrayList<LayoutEntry>(parsedEntries.size());
        ArrayList<StringInt> blockEntries = null;
        String blockStart = null;
        for (StringInt parsedEntry : parsedEntries) {
            switch (parsedEntry.i) {
                case 1: 
                case 2: 
                case 5: {
                    break;
                }
                case 3: 
                case 6: {
                    blockEntries = new ArrayList<StringInt>();
                    blockStart = parsedEntry.s;
                    break;
                }
                case 4: 
                case 7: {
                    if (blockStart == null || blockEntries == null) break;
                    if (blockStart.equals(parsedEntry.s)) {
                        blockEntries.add(parsedEntry);
                        LayoutEntry le = new LayoutEntry(blockEntries, parsedEntry.i == 4 ? 3 : 6, prefs);
                        tmpEntries.add(le);
                        blockEntries = null;
                        break;
                    }
                    LOGGER.debug(blockStart + '\n' + parsedEntry.s);
                    LOGGER.warn("Nested field/group entries are not implemented!");
                    Thread.dumpStack();
                    break;
                }
            }
            if (blockEntries == null) {
                tmpEntries.add(new LayoutEntry(parsedEntry, prefs));
                continue;
            }
            blockEntries.add(parsedEntry);
        }
        this.layoutEntries = new ArrayList<LayoutEntry>(tmpEntries);
        for (LayoutEntry layoutEntry : this.layoutEntries) {
            this.missingFormatters.addAll(layoutEntry.getInvalidFormatters());
        }
    }

    public void setPostFormatter(LayoutFormatter formatter) {
        for (LayoutEntry layoutEntry : this.layoutEntries) {
            layoutEntry.setPostFormatter(formatter);
        }
    }

    public String doLayout(BibEntry bibtex, BibDatabase database) {
        StringBuilder sb = new StringBuilder(100);
        for (LayoutEntry layoutEntry : this.layoutEntries) {
            String fieldText = layoutEntry.doLayout(bibtex, database);
            if (fieldText == null) {
                fieldText = "";
            }
            sb.append(fieldText);
        }
        return sb.toString();
    }

    public String doLayout(BibDatabaseContext databaseContext, Charset encoding) {
        StringBuilder sb = new StringBuilder(100);
        for (LayoutEntry layoutEntry : this.layoutEntries) {
            String fieldText = layoutEntry.doLayout(databaseContext, encoding);
            if (fieldText == null) {
                fieldText = "";
            }
            sb.append(fieldText);
        }
        return sb.toString();
    }

    public List<String> getMissingFormatters() {
        return new ArrayList<String>(this.missingFormatters);
    }
}

