/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.layout;

import java.util.ArrayList;
import java.util.List;
import net.sf.jabref.logic.layout.ParamLayoutFormatter;

public abstract class AbstractParamLayoutFormatter
implements ParamLayoutFormatter {
    private static final char SEPARATOR = ',';

    protected static List<String> parseArgument(String arg) {
        ArrayList<String> parts = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean escaped = false;
        for (int i = 0; i < arg.length(); ++i) {
            if (arg.charAt(i) == ',' && !escaped) {
                parts.add(current.toString());
                current = new StringBuilder();
                continue;
            }
            if (arg.charAt(i) == '\\') {
                if (escaped) {
                    escaped = false;
                    current.append(arg.charAt(i));
                    continue;
                }
                escaped = true;
                continue;
            }
            if (escaped) {
                if (arg.charAt(i) == 'n') {
                    current.append('\n');
                } else if (arg.charAt(i) == 't') {
                    current.append('\t');
                } else {
                    if (arg.charAt(i) != ',' && arg.charAt(i) != '\"') {
                        current.append('\\');
                    }
                    current.append(arg.charAt(i));
                }
                escaped = false;
                continue;
            }
            current.append(arg.charAt(i));
        }
        parts.add(current.toString());
        return parts;
    }
}

