/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.l10n;

import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;

public class Languages {
    public static final Map<String, String> LANGUAGES = new TreeMap<String, String>();

    public static Optional<Locale> convertToSupportedLocale(String language) {
        Objects.requireNonNull(language);
        if (!LANGUAGES.values().contains(language)) {
            if (!language.contains("_")) {
                return Optional.empty();
            }
            String lang = language.split("_")[0];
            if (!LANGUAGES.values().contains(lang)) {
                return Optional.empty();
            }
            return Optional.of(new Locale(lang));
        }
        return Optional.of(new Locale(language));
    }

    static {
        LANGUAGES.put("Dansk", "da");
        LANGUAGES.put("Deutsch", "de");
        LANGUAGES.put("English", "en");
        LANGUAGES.put("Espa\u00f1ol", "es");
        LANGUAGES.put("Persian (\u0641\u0627\u0631\u0633\u06cc)", "fa");
        LANGUAGES.put("Fran\u00e7ais", "fr");
        LANGUAGES.put("Bahasa Indonesia", "in");
        LANGUAGES.put("Italiano", "it");
        LANGUAGES.put("Japanese", "ja");
        LANGUAGES.put("Nederlands", "nl");
        LANGUAGES.put("Norsk", "no");
        LANGUAGES.put("Brazilian Portuguese", "pt_BR");
        LANGUAGES.put("Russian", "ru");
        LANGUAGES.put("Svenska", "sv");
        LANGUAGES.put("Turkish", "tr");
        LANGUAGES.put("Vietnamese", "vi");
        LANGUAGES.put("Simplified Chinese", "zh");
    }
}

