/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.l10n;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class EncodingControl
extends ResourceBundle.Control {
    private final Charset encoding;

    public EncodingControl(Charset encoding) {
        this.encoding = encoding;
    }

    @Override
    public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
        String bundleName = this.toBundleName(baseName, locale);
        String resourceName = this.toResourceName(bundleName, "properties");
        PropertyResourceBundle bundle = null;
        if (reload) {
            URLConnection connection;
            URL url = loader.getResource(resourceName);
            if (url != null && (connection = url.openConnection()) != null) {
                connection.setUseCaches(false);
                try (InputStream stream = connection.getInputStream();){
                    bundle = new PropertyResourceBundle(new InputStreamReader(stream, this.encoding));
                }
            }
        } else {
            try (InputStream stream = loader.getResourceAsStream(resourceName);){
                bundle = new PropertyResourceBundle(new InputStreamReader(stream, this.encoding));
            }
        }
        return bundle;
    }
}

