/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.journals;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.jabref.logic.journals.Abbreviation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JournalAbbreviationRepository {
    private final Map<String, Abbreviation> fullNameLowerCase2Abbreviation = new HashMap<String, Abbreviation>();
    private final Map<String, Abbreviation> isoLowerCase2Abbreviation = new HashMap<String, Abbreviation>();
    private final Map<String, Abbreviation> medlineLowerCase2Abbreviation = new HashMap<String, Abbreviation>();
    private final SortedSet<Abbreviation> abbreviations = new TreeSet<Abbreviation>();
    private static final Log LOGGER = LogFactory.getLog(JournalAbbreviationRepository.class);

    public int size() {
        return this.abbreviations.size();
    }

    public boolean isKnownName(String journalName) {
        String nameKey = Objects.requireNonNull(journalName).trim().toLowerCase(Locale.ENGLISH);
        return this.fullNameLowerCase2Abbreviation.containsKey(nameKey) || this.isoLowerCase2Abbreviation.containsKey(nameKey) || this.medlineLowerCase2Abbreviation.containsKey(nameKey);
    }

    public boolean isAbbreviatedName(String journalName) {
        String nameKey = Objects.requireNonNull(journalName).trim().toLowerCase(Locale.ENGLISH);
        return this.isoLowerCase2Abbreviation.containsKey(nameKey) || this.medlineLowerCase2Abbreviation.containsKey(nameKey);
    }

    public Optional<Abbreviation> getAbbreviation(String journalName) {
        String nameKey = Objects.requireNonNull(journalName).toLowerCase(Locale.ENGLISH).trim();
        if (this.fullNameLowerCase2Abbreviation.containsKey(nameKey)) {
            return Optional.of(this.fullNameLowerCase2Abbreviation.get(nameKey));
        }
        if (this.isoLowerCase2Abbreviation.containsKey(nameKey)) {
            return Optional.of(this.isoLowerCase2Abbreviation.get(nameKey));
        }
        if (this.medlineLowerCase2Abbreviation.containsKey(nameKey)) {
            return Optional.of(this.medlineLowerCase2Abbreviation.get(nameKey));
        }
        return Optional.empty();
    }

    public void addEntry(Abbreviation abbreviation) {
        Objects.requireNonNull(abbreviation);
        if (this.isKnownName(abbreviation.getName())) {
            Abbreviation previous = this.getAbbreviation(abbreviation.getName()).get();
            this.abbreviations.remove(previous);
            LOGGER.info("Duplicate journal abbreviation - old one will be overwritten by new one\nOLD: " + previous + "\nNEW: " + abbreviation);
        }
        this.abbreviations.add(abbreviation);
        this.fullNameLowerCase2Abbreviation.put(abbreviation.getName().toLowerCase(Locale.ENGLISH), abbreviation);
        this.isoLowerCase2Abbreviation.put(abbreviation.getIsoAbbreviation().toLowerCase(Locale.ENGLISH), abbreviation);
        this.medlineLowerCase2Abbreviation.put(abbreviation.getMedlineAbbreviation().toLowerCase(Locale.ENGLISH), abbreviation);
    }

    public void addEntries(List<Abbreviation> abbreviationsToAdd) {
        abbreviationsToAdd.forEach(this::addEntry);
    }

    public SortedSet<Abbreviation> getAbbreviations() {
        return Collections.unmodifiableSortedSet(this.abbreviations);
    }

    public Optional<String> getNextAbbreviation(String text) {
        Optional<Abbreviation> abbreviation = this.getAbbreviation(text);
        if (!abbreviation.isPresent()) {
            return Optional.empty();
        }
        Abbreviation abbr = abbreviation.get();
        return Optional.of(abbr.getNext(text));
    }

    public Optional<String> getMedlineAbbreviation(String text) {
        Optional<Abbreviation> abbreviation = this.getAbbreviation(text);
        if (!abbreviation.isPresent()) {
            return Optional.empty();
        }
        Abbreviation abbr = abbreviation.get();
        return Optional.of(abbr.getMedlineAbbreviation());
    }

    public Optional<String> getIsoAbbreviation(String text) {
        Optional<Abbreviation> abbreviation = this.getAbbreviation(text);
        if (!abbreviation.isPresent()) {
            return Optional.empty();
        }
        Abbreviation abbr = abbreviation.get();
        return Optional.of(abbr.getIsoAbbreviation());
    }
}

