/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.journals;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.sf.jabref.logic.journals.Abbreviation;
import net.sf.jabref.logic.journals.JournalAbbreviationRepository;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AbbreviationParser {
    private final List<Abbreviation> abbreviations = new LinkedList<Abbreviation>();
    private static final Log LOGGER = LogFactory.getLog(AbbreviationParser.class);

    public void readJournalListFromResource(String resourceFileName) {
        URL url = Objects.requireNonNull(JournalAbbreviationRepository.class.getResource(Objects.requireNonNull(resourceFileName)));
        try {
            this.readJournalList(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            LOGGER.info("Could not read journal list from file " + resourceFileName, e);
        }
    }

    public void readJournalListFromFile(File file) throws FileNotFoundException {
        try (FileReader reader = new FileReader(Objects.requireNonNull(file));){
            this.readJournalList(reader);
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            LOGGER.warn("Could not read journal list from file " + file.getAbsolutePath(), e);
        }
    }

    public void readJournalListFromFile(File file, Charset encoding) throws FileNotFoundException {
        try (FileInputStream stream = new FileInputStream(Objects.requireNonNull(file));
             InputStreamReader reader = new InputStreamReader((InputStream)stream, Objects.requireNonNull(encoding));){
            this.readJournalList(reader);
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            LOGGER.warn("Could not read journal list from file " + file.getAbsolutePath(), e);
        }
    }

    private void readJournalList(Reader in) {
        try (BufferedReader reader = new BufferedReader(in);){
            String line;
            while ((line = reader.readLine()) != null) {
                this.addLine(line);
            }
        }
        catch (IOException ex) {
            LOGGER.info("Could not read journal list from file ", ex);
        }
    }

    private void addLine(String line) {
        if (line.startsWith("#")) {
            return;
        }
        String[] parts = line.split("=");
        if (parts.length == 2) {
            String fullName = parts[0].trim();
            String abbrName = parts[1].trim();
            if (fullName.length() <= 0 || abbrName.length() <= 0) {
                return;
            }
            Abbreviation abbreviation = new Abbreviation(fullName, abbrName);
            this.abbreviations.add(abbreviation);
        }
    }

    public List<Abbreviation> getAbbreviations() {
        return new LinkedList<Abbreviation>(this.abbreviations);
    }
}

