/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.journals;

import java.util.Objects;

public class Abbreviation
implements Comparable<Abbreviation> {
    private static final String SPLITTER = ";";
    private final String name;
    private final String abbreviation;

    public Abbreviation(String name, String abbreviation) {
        this.name = Objects.requireNonNull(name).trim();
        this.abbreviation = Objects.requireNonNull(abbreviation).trim();
    }

    public String getName() {
        return this.name;
    }

    public String getIsoAbbreviation() {
        if (this.abbreviation.contains(SPLITTER)) {
            String[] restParts = this.abbreviation.split(SPLITTER);
            return restParts[0].trim();
        }
        return this.abbreviation;
    }

    public String getMedlineAbbreviation() {
        return this.getIsoAbbreviation().replace(".", " ").replace("  ", " ").trim();
    }

    @Override
    public int compareTo(Abbreviation toCompare) {
        return this.name.compareTo(toCompare.name);
    }

    public String getNext(String current) {
        String currentTrimmed = current.trim();
        if (this.getMedlineAbbreviation().equals(currentTrimmed)) {
            return this.getName();
        }
        if (this.getName().equals(currentTrimmed)) {
            return this.getIsoAbbreviation();
        }
        return this.getMedlineAbbreviation();
    }

    public String toString() {
        return String.format("Abbreviation{name=%s, iso=%s, medline=%s}", this.name, this.getIsoAbbreviation(), this.getMedlineAbbreviation());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Abbreviation) {
            Abbreviation that = (Abbreviation)o;
            return Objects.equals(this.name, that.name);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.name);
    }
}

