/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.integrity;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.sf.jabref.logic.integrity.IntegrityCheck;
import net.sf.jabref.logic.integrity.IntegrityMessage;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.entry.BibEntry;

public class YearChecker
implements IntegrityCheck.Checker {
    private static final Predicate<String> CONTAINS_FOUR_DIGIT = Pattern.compile("([^0-9]|^)[0-9]{4}([^0-9]|$)").asPredicate();
    private static final Predicate<String> ENDS_WITH_FOUR_DIGIT = Pattern.compile("[0-9]{4}$").asPredicate();
    private static final String PUNCTUATION_MARKS = "[(){},.;!?<>%&$]";

    @Override
    public List<IntegrityMessage> check(BibEntry entry) {
        Optional<String> value = entry.getField("year");
        if (!value.isPresent()) {
            return Collections.emptyList();
        }
        if (!CONTAINS_FOUR_DIGIT.test(value.get().trim())) {
            return Collections.singletonList(new IntegrityMessage(Localization.lang("should contain a four digit number", new String[0]), entry, "year"));
        }
        if (!ENDS_WITH_FOUR_DIGIT.test(value.get().replaceAll(PUNCTUATION_MARKS, ""))) {
            return Collections.singletonList(new IntegrityMessage(Localization.lang("last four nonpunctuation characters should be numerals", new String[0]), entry, "year"));
        }
        return Collections.emptyList();
    }
}

