/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.integrity;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jabref.logic.integrity.IntegrityCheck;
import net.sf.jabref.logic.integrity.IntegrityMessage;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.entry.BibEntry;

public class TitleChecker
implements IntegrityCheck.Checker {
    private static final Pattern INSIDE_CURLY_BRAKETS = Pattern.compile("\\{[^}\\{]*\\}");
    private static final Predicate<String> HAS_CAPITAL_LETTERS = Pattern.compile("[\\p{Lu}\\p{Lt}]").asPredicate();

    @Override
    public List<IntegrityMessage> check(BibEntry entry) {
        Matcher matcher;
        String valueIgnoringFirstLetter;
        Optional<String> value = entry.getField("title");
        if (!value.isPresent()) {
            return Collections.emptyList();
        }
        String valueTrimmed = value.get().trim();
        String valueOnlySpacesWithinCurlyBraces = valueIgnoringFirstLetter = valueTrimmed.startsWith("{") ? valueTrimmed : valueTrimmed.substring(1);
        while ((matcher = INSIDE_CURLY_BRAKETS.matcher(valueOnlySpacesWithinCurlyBraces)).find()) {
            valueOnlySpacesWithinCurlyBraces = matcher.replaceAll("");
        }
        boolean hasCapitalLettersThatBibtexWillConvertToSmallerOnes = HAS_CAPITAL_LETTERS.test(valueOnlySpacesWithinCurlyBraces);
        if (hasCapitalLettersThatBibtexWillConvertToSmallerOnes) {
            return Collections.singletonList(new IntegrityMessage(Localization.lang("capital letters are not masked using curly brackets {}", new String[0]), entry, "title"));
        }
        return Collections.emptyList();
    }
}

