/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.integrity;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.sf.jabref.logic.integrity.IntegrityCheck;
import net.sf.jabref.logic.integrity.IntegrityMessage;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.entry.BibEntry;

public class PagesChecker
implements IntegrityCheck.Checker {
    private static final String PAGES_EXP = "\\A\\d+(?:\\+|\\-{2}\\d+)?(?:,\\d+(?:\\+|\\-{2}\\d+)?)*\\z";
    private static final Predicate<String> VALID_PAGE_NUMBER = Pattern.compile("\\A\\d+(?:\\+|\\-{2}\\d+)?(?:,\\d+(?:\\+|\\-{2}\\d+)?)*\\z").asPredicate();

    @Override
    public List<IntegrityMessage> check(BibEntry entry) {
        Optional<String> value = entry.getField("pages");
        if (!value.isPresent()) {
            return Collections.emptyList();
        }
        if (!VALID_PAGE_NUMBER.test(value.get().trim())) {
            return Collections.singletonList(new IntegrityMessage(Localization.lang("should contain a valid page number range", new String[0]), entry, "pages"));
        }
        return Collections.emptyList();
    }
}

