/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.integrity;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.sf.jabref.logic.integrity.IntegrityCheck;
import net.sf.jabref.logic.integrity.IntegrityMessage;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.entry.BibEntry;

public class NoBibtexFieldChecker
implements IntegrityCheck.Checker {
    @Override
    public List<IntegrityMessage> check(BibEntry entry) {
        Optional<String> value = entry.getField("journaltitle");
        if (!value.isPresent()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new IntegrityMessage(Localization.lang("BibLaTeX field only", new String[0]), entry, "journaltitle"));
    }
}

