/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.integrity;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.sf.jabref.logic.integrity.IntegrityCheck;
import net.sf.jabref.logic.integrity.IntegrityMessage;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.database.BibDatabaseContext;
import net.sf.jabref.model.entry.BibEntry;

public class MonthChecker
implements IntegrityCheck.Checker {
    private static final Predicate<String> ONLY_AN_INTEGER = Pattern.compile("[1-9]|10|11|12").asPredicate();
    private static final Predicate<String> MONTH_NORMALIZED = Pattern.compile("#jan#|#feb#|#mar#|#apr#|#may#|#jun#|#jul#|#aug#|#sep#|#oct#|#nov#|#dec#").asPredicate();
    private final BibDatabaseContext bibDatabaseContextMonth;

    public MonthChecker(BibDatabaseContext bibDatabaseContext) {
        this.bibDatabaseContextMonth = Objects.requireNonNull(bibDatabaseContext);
    }

    @Override
    public List<IntegrityMessage> check(BibEntry entry) {
        Optional<String> value = entry.getField("month");
        if (!value.isPresent()) {
            return Collections.emptyList();
        }
        if (this.bibDatabaseContextMonth.isBiblatexMode() && !ONLY_AN_INTEGER.test(value.get().trim()) && !MONTH_NORMALIZED.test(value.get().trim())) {
            return Collections.singletonList(new IntegrityMessage(Localization.lang("should be an integer or normalized", new String[0]), entry, "month"));
        }
        if (!this.bibDatabaseContextMonth.isBiblatexMode() && !MONTH_NORMALIZED.test(value.get().trim())) {
            return Collections.singletonList(new IntegrityMessage(Localization.lang("should be normalized", new String[0]), entry, "month"));
        }
        return Collections.emptyList();
    }
}

