/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.integrity;

import net.sf.jabref.model.entry.BibEntry;

public class IntegrityMessage
implements Cloneable {
    private final BibEntry entry;
    private final String fieldName;
    private final String message;

    public IntegrityMessage(String message, BibEntry entry, String fieldName) {
        this.message = message;
        this.entry = entry;
        this.fieldName = fieldName;
    }

    public String toString() {
        return "[" + this.getEntry().getCiteKeyOptional().orElse("") + "] in " + this.getFieldName() + ": " + this.getMessage();
    }

    public String getMessage() {
        return this.message;
    }

    public BibEntry getEntry() {
        return this.entry;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Object clone() {
        return new IntegrityMessage(this.message, this.entry, this.fieldName);
    }
}

