/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.integrity;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.sf.jabref.logic.integrity.ASCIICharacterChecker;
import net.sf.jabref.logic.integrity.AbbreviationChecker;
import net.sf.jabref.logic.integrity.AuthorNameChecker;
import net.sf.jabref.logic.integrity.BibStringChecker;
import net.sf.jabref.logic.integrity.BiblatexPagesChecker;
import net.sf.jabref.logic.integrity.BibtexkeyChecker;
import net.sf.jabref.logic.integrity.BooktitleChecker;
import net.sf.jabref.logic.integrity.BracketChecker;
import net.sf.jabref.logic.integrity.EditionChecker;
import net.sf.jabref.logic.integrity.EntryLinkChecker;
import net.sf.jabref.logic.integrity.FileChecker;
import net.sf.jabref.logic.integrity.HTMLCharacterChecker;
import net.sf.jabref.logic.integrity.HowpublishedChecker;
import net.sf.jabref.logic.integrity.ISBNChecker;
import net.sf.jabref.logic.integrity.ISSNChecker;
import net.sf.jabref.logic.integrity.IntegrityMessage;
import net.sf.jabref.logic.integrity.MonthChecker;
import net.sf.jabref.logic.integrity.NoBibtexFieldChecker;
import net.sf.jabref.logic.integrity.NoteChecker;
import net.sf.jabref.logic.integrity.PagesChecker;
import net.sf.jabref.logic.integrity.TitleChecker;
import net.sf.jabref.logic.integrity.TypeChecker;
import net.sf.jabref.logic.integrity.UrlChecker;
import net.sf.jabref.logic.integrity.YearChecker;
import net.sf.jabref.model.database.BibDatabaseContext;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.InternalBibtexFields;
import net.sf.jabref.model.metadata.FileDirectoryPreferences;

public class IntegrityCheck {
    private final BibDatabaseContext bibDatabaseContext;
    private final FileDirectoryPreferences fileDirectoryPreferences;

    public IntegrityCheck(BibDatabaseContext bibDatabaseContext, FileDirectoryPreferences fileDirectoryPreferences) {
        this.bibDatabaseContext = Objects.requireNonNull(bibDatabaseContext);
        this.fileDirectoryPreferences = Objects.requireNonNull(fileDirectoryPreferences);
    }

    public List<IntegrityMessage> checkBibtexDatabase() {
        ArrayList<IntegrityMessage> result = new ArrayList<IntegrityMessage>();
        for (BibEntry entry : this.bibDatabaseContext.getDatabase().getEntries()) {
            result.addAll(this.checkBibtexEntry(entry));
        }
        return result;
    }

    private List<IntegrityMessage> checkBibtexEntry(BibEntry entry) {
        ArrayList<IntegrityMessage> result = new ArrayList<IntegrityMessage>();
        if (entry == null) {
            return result;
        }
        result.addAll(new AuthorNameChecker().check(entry));
        if (!this.bibDatabaseContext.isBiblatexMode()) {
            result.addAll(new TitleChecker().check(entry));
            result.addAll(new PagesChecker().check(entry));
            result.addAll(new ASCIICharacterChecker().check(entry));
            result.addAll(new NoBibtexFieldChecker().check(entry));
        } else {
            result.addAll(new BiblatexPagesChecker().check(entry));
        }
        result.addAll(new BracketChecker("title").check(entry));
        result.addAll(new YearChecker().check(entry));
        result.addAll(new BibtexkeyChecker().check(entry));
        result.addAll(new EditionChecker(this.bibDatabaseContext).check(entry));
        result.addAll(new NoteChecker(this.bibDatabaseContext).check(entry));
        result.addAll(new HowpublishedChecker(this.bibDatabaseContext).check(entry));
        result.addAll(new MonthChecker(this.bibDatabaseContext).check(entry));
        result.addAll(new UrlChecker().check(entry));
        result.addAll(new FileChecker(this.bibDatabaseContext, this.fileDirectoryPreferences).check(entry));
        result.addAll(new TypeChecker().check(entry));
        for (String journalField : InternalBibtexFields.getJournalNameFields()) {
            result.addAll(new AbbreviationChecker(journalField).check(entry));
        }
        for (String bookNameField : InternalBibtexFields.getBookNameFields()) {
            result.addAll(new AbbreviationChecker(bookNameField).check(entry));
        }
        result.addAll(new BibStringChecker().check(entry));
        result.addAll(new HTMLCharacterChecker().check(entry));
        result.addAll(new BooktitleChecker().check(entry));
        result.addAll(new ISSNChecker().check(entry));
        result.addAll(new ISBNChecker().check(entry));
        result.addAll(new EntryLinkChecker(this.bibDatabaseContext.getDatabase()).check(entry));
        return result;
    }

    @FunctionalInterface
    public static interface Checker {
        public List<IntegrityMessage> check(BibEntry var1);
    }
}

