/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.integrity;

import java.util.Collections;
import java.util.List;
import net.sf.jabref.logic.integrity.IntegrityCheck;
import net.sf.jabref.logic.integrity.IntegrityMessage;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.util.ISSN;
import net.sf.jabref.model.entry.BibEntry;

public class ISSNChecker
implements IntegrityCheck.Checker {
    @Override
    public List<IntegrityMessage> check(BibEntry entry) {
        if (!entry.hasField("issn")) {
            return Collections.emptyList();
        }
        String issnString = entry.getField("issn").get().trim();
        ISSN issn = new ISSN(issnString);
        if (!issn.isValidFormat()) {
            return Collections.singletonList(new IntegrityMessage(Localization.lang("incorrect format", new String[0]), entry, "issn"));
        }
        if (issn.isValidChecksum()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new IntegrityMessage(Localization.lang("incorrect control digit", new String[0]), entry, "issn"));
    }
}

