/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.integrity;

import java.util.Collections;
import java.util.List;
import net.sf.jabref.logic.integrity.IntegrityCheck;
import net.sf.jabref.logic.integrity.IntegrityMessage;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.util.ISBN;
import net.sf.jabref.model.entry.BibEntry;

public class ISBNChecker
implements IntegrityCheck.Checker {
    @Override
    public List<IntegrityMessage> check(BibEntry entry) {
        if (!entry.hasField("isbn")) {
            return Collections.emptyList();
        }
        ISBN isbn = new ISBN(entry.getField("isbn").get());
        if (!isbn.isValidFormat()) {
            return Collections.singletonList(new IntegrityMessage(Localization.lang("incorrect format", new String[0]), entry, "isbn"));
        }
        if (!isbn.isValidChecksum()) {
            return Collections.singletonList(new IntegrityMessage(Localization.lang("incorrect control digit", new String[0]), entry, "isbn"));
        }
        return Collections.emptyList();
    }
}

