/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.integrity;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jabref.logic.integrity.IntegrityCheck;
import net.sf.jabref.logic.integrity.IntegrityMessage;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.FieldProperty;
import net.sf.jabref.model.entry.InternalBibtexFields;

public class HTMLCharacterChecker
implements IntegrityCheck.Checker {
    private static final Pattern HTML_CHARACTER_PATTERN = Pattern.compile("&[#\\p{Alnum}]+;");

    @Override
    public List<IntegrityMessage> check(BibEntry entry) {
        ArrayList<IntegrityMessage> results = new ArrayList<IntegrityMessage>();
        for (Map.Entry<String, String> field : entry.getFieldMap().entrySet()) {
            Matcher characterMatcher;
            if (InternalBibtexFields.getFieldProperties(field.getKey()).contains((Object)FieldProperty.VERBATIM) || !(characterMatcher = HTML_CHARACTER_PATTERN.matcher(field.getValue())).find()) continue;
            results.add(new IntegrityMessage(Localization.lang("HTML encoded character found", new String[0]), entry, field.getKey()));
        }
        return results;
    }
}

