/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.integrity;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.sf.jabref.logic.integrity.IntegrityCheck;
import net.sf.jabref.logic.integrity.IntegrityMessage;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.util.io.FileUtil;
import net.sf.jabref.model.database.BibDatabaseContext;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.FileField;
import net.sf.jabref.model.entry.ParsedFileField;
import net.sf.jabref.model.metadata.FileDirectoryPreferences;

public class FileChecker
implements IntegrityCheck.Checker {
    private final BibDatabaseContext context;
    private final FileDirectoryPreferences fileDirectoryPreferences;

    public FileChecker(BibDatabaseContext context, FileDirectoryPreferences fileDirectoryPreferences) {
        this.context = context;
        this.fileDirectoryPreferences = fileDirectoryPreferences;
    }

    @Override
    public List<IntegrityMessage> check(BibEntry entry) {
        Optional<String> value = entry.getField("file");
        if (!value.isPresent()) {
            return Collections.emptyList();
        }
        List parsedFileFields = FileField.parse(value.get()).stream().filter(p -> !p.getLink().startsWith("http://") && !p.getLink().startsWith("https://")).collect(Collectors.toList());
        for (ParsedFileField p2 : parsedFileFields) {
            Optional<File> file = FileUtil.expandFilename(this.context, p2.getLink(), this.fileDirectoryPreferences);
            if (file.isPresent() && file.get().exists()) continue;
            return Collections.singletonList(new IntegrityMessage(Localization.lang("link should refer to a correct file path", new String[0]), entry, "file"));
        }
        return Collections.emptyList();
    }
}

