/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.integrity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.sf.jabref.logic.integrity.IntegrityCheck;
import net.sf.jabref.logic.integrity.IntegrityMessage;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.database.BibDatabase;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.FieldProperty;
import net.sf.jabref.model.entry.InternalBibtexFields;

public class EntryLinkChecker
implements IntegrityCheck.Checker {
    private final BibDatabase database;

    public EntryLinkChecker(BibDatabase database) {
        this.database = Objects.requireNonNull(database);
    }

    @Override
    public List<IntegrityMessage> check(BibEntry entry) {
        ArrayList<IntegrityMessage> result = new ArrayList<IntegrityMessage>();
        for (Map.Entry<String, String> field : entry.getFieldMap().entrySet()) {
            Set<FieldProperty> properties = InternalBibtexFields.getFieldProperties(field.getKey());
            if (properties.contains((Object)FieldProperty.SINGLE_ENTRY_LINK)) {
                if (this.database.getEntryByKey(field.getValue()).isPresent()) continue;
                result.add(new IntegrityMessage(Localization.lang("Referenced BibTeX key does not exist", new String[0]), entry, field.getKey()));
                continue;
            }
            if (!properties.contains((Object)FieldProperty.MULTIPLE_ENTRY_LINK)) continue;
            ArrayList<String> keys = new ArrayList<String>(Arrays.asList(field.getValue().split(",")));
            for (String key : keys) {
                if (this.database.getEntryByKey(key).isPresent()) continue;
                result.add(new IntegrityMessage(Localization.lang("Referenced BibTeX key does not exist", new String[0]) + ": " + key, entry, field.getKey()));
            }
        }
        return result;
    }
}

