/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.integrity;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.sf.jabref.logic.integrity.IntegrityCheck;
import net.sf.jabref.logic.integrity.IntegrityMessage;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.entry.BibEntry;

public class BracketChecker
implements IntegrityCheck.Checker {
    private final String field;

    public BracketChecker(String field) {
        this.field = field;
    }

    @Override
    public List<IntegrityMessage> check(BibEntry entry) {
        Optional<String> value = entry.getField(this.field);
        if (!value.isPresent()) {
            return Collections.emptyList();
        }
        int counter = 0;
        for (char a : value.get().trim().toCharArray()) {
            if (a == '{') {
                ++counter;
                continue;
            }
            if (a != '}') continue;
            if (counter == 0) {
                return Collections.singletonList(new IntegrityMessage(Localization.lang("unexpected closing curly bracket", new String[0]), entry, this.field));
            }
            --counter;
        }
        if (counter > 0) {
            return Collections.singletonList(new IntegrityMessage(Localization.lang("unexpected opening curly bracket", new String[0]), entry, this.field));
        }
        return Collections.emptyList();
    }
}

