/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.integrity;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.sf.jabref.logic.integrity.IntegrityCheck;
import net.sf.jabref.logic.integrity.IntegrityMessage;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.strings.StringUtil;

public class BibtexkeyChecker
implements IntegrityCheck.Checker {
    @Override
    public List<IntegrityMessage> check(BibEntry entry) {
        Optional<String> valuekey = entry.getCiteKeyOptional();
        Optional<String> valueauthor = entry.getField("author");
        Optional<String> valuetitle = entry.getField("title");
        Optional<String> valueyear = entry.getField("year");
        String authortitleyear = entry.getAuthorTitleYear(100);
        if (!(valueauthor.isPresent() && valuetitle.isPresent() && valueyear.isPresent())) {
            return Collections.emptyList();
        }
        if (StringUtil.isBlank(valuekey)) {
            return Collections.singletonList(new IntegrityMessage(Localization.lang("empty BibTeX key", new String[0]) + ": " + authortitleyear, entry, "bibtexkey"));
        }
        return Collections.emptyList();
    }
}

