/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.integrity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.sf.jabref.logic.integrity.IntegrityCheck;
import net.sf.jabref.logic.integrity.IntegrityMessage;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.FieldProperty;
import net.sf.jabref.model.entry.InternalBibtexFields;

public class AuthorNameChecker
implements IntegrityCheck.Checker {
    @Override
    public List<IntegrityMessage> check(BibEntry entry) {
        ArrayList<IntegrityMessage> result = new ArrayList<IntegrityMessage>();
        for (String field : entry.getFieldNames()) {
            if (!InternalBibtexFields.getFieldProperties(field).contains((Object)FieldProperty.PERSON_NAMES)) continue;
            Optional<String> value = entry.getField(field);
            if (!value.isPresent()) {
                return Collections.emptyList();
            }
            String valueTrimmedAndLowerCase = value.get().trim().toLowerCase();
            if (valueTrimmedAndLowerCase.startsWith("and ") || valueTrimmedAndLowerCase.startsWith(",")) {
                result.add(new IntegrityMessage(Localization.lang("should start with a name", new String[0]), entry, field));
                continue;
            }
            if (!valueTrimmedAndLowerCase.endsWith(" and") && !valueTrimmedAndLowerCase.endsWith(",")) continue;
            result.add(new IntegrityMessage(Localization.lang("should end with a name", new String[0]), entry, field));
        }
        return result;
    }
}

