/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.integrity;

import com.google.common.base.CharMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jabref.logic.integrity.IntegrityCheck;
import net.sf.jabref.logic.integrity.IntegrityMessage;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.entry.BibEntry;

public class ASCIICharacterChecker
implements IntegrityCheck.Checker {
    @Override
    public List<IntegrityMessage> check(BibEntry entry) {
        ArrayList<IntegrityMessage> results = new ArrayList<IntegrityMessage>();
        for (Map.Entry<String, String> field : entry.getFieldMap().entrySet()) {
            boolean asciiOnly = CharMatcher.ascii().matchesAllOf(field.getValue());
            if (asciiOnly) continue;
            results.add(new IntegrityMessage(Localization.lang("Non-ASCII encoded character found", new String[0]), entry, field.getKey()));
        }
        return results;
    }
}

