/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.importer.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.sf.jabref.logic.cleanup.Cleanups;
import net.sf.jabref.logic.groups.GroupsParser;
import net.sf.jabref.logic.importer.ParseException;
import net.sf.jabref.model.database.BibDatabaseMode;
import net.sf.jabref.model.metadata.MetaData;
import net.sf.jabref.model.metadata.SaveOrderConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MetaDataParser {
    private static final Log LOGGER = LogFactory.getLog(MetaDataParser.class);

    public static MetaData parse(Map<String, String> data, Character keywordSeparator) throws ParseException {
        MetaData metaData = new MetaData();
        List<String> defaultCiteKeyPattern = new ArrayList<String>();
        HashMap<String, List<String>> nonDefaultCiteKeyPatterns = new HashMap<String, List<String>>();
        for (Map.Entry<String, String> entry : data.entrySet()) {
            List<String> value = MetaDataParser.getAsList(entry.getValue());
            if (entry.getKey().startsWith("selector_")) continue;
            if (entry.getKey().startsWith("keypattern_")) {
                String entryType = entry.getKey().substring("keypattern_".length());
                nonDefaultCiteKeyPatterns.put(entryType, Collections.singletonList(MetaDataParser.getSingleItem(value)));
                continue;
            }
            if (entry.getKey().startsWith("fileDirectory-")) {
                String user = entry.getKey().substring("fileDirectory".length() + 1);
                metaData.setUserFileDirectory(user, MetaDataParser.getSingleItem(value));
                continue;
            }
            switch (entry.getKey()) {
                case "groupstree": {
                    metaData.setGroups(GroupsParser.importGroups(value, keywordSeparator));
                    break;
                }
                case "saveActions": {
                    metaData.setSaveActions(Cleanups.parse(value));
                    break;
                }
                case "databaseType": {
                    metaData.setMode(BibDatabaseMode.parse(MetaDataParser.getSingleItem(value)));
                    break;
                }
                case "keypatterndefault": {
                    defaultCiteKeyPattern = Collections.singletonList(MetaDataParser.getSingleItem(value));
                    break;
                }
                case "protectedFlag": {
                    if (Boolean.parseBoolean(MetaDataParser.getSingleItem(value))) {
                        metaData.markAsProtected();
                        break;
                    }
                    metaData.markAsNotProtected();
                    break;
                }
                case "fileDirectory": {
                    metaData.setDefaultFileDirectory(MetaDataParser.getSingleItem(value));
                    break;
                }
                case "saveOrderConfig": {
                    metaData.setSaveOrderConfig(SaveOrderConfig.parse(value));
                    break;
                }
            }
        }
        if (!defaultCiteKeyPattern.isEmpty() || !nonDefaultCiteKeyPatterns.isEmpty()) {
            metaData.setCiteKeyPattern(defaultCiteKeyPattern, nonDefaultCiteKeyPatterns);
        }
        return metaData;
    }

    private static String getSingleItem(List<String> value) throws ParseException {
        if (value.size() == 1) {
            return value.get(0);
        }
        throw new ParseException("Expected a single item but received " + value.toString());
    }

    private static List<String> getAsList(String value) throws ParseException {
        StringReader valueReader = new StringReader(value);
        ArrayList<String> orderedValue = new ArrayList<String>();
        try {
            Optional<String> unit;
            while ((unit = MetaDataParser.getNextUnit(valueReader)).isPresent()) {
                orderedValue.add(unit.get());
            }
        }
        catch (IOException ex) {
            LOGGER.error("Weird error while parsing meta data.", ex);
            throw new ParseException("Weird error while parsing meta data.", ex);
        }
        return orderedValue;
    }

    private static Optional<String> getNextUnit(Reader reader) throws IOException {
        int c;
        boolean escape = false;
        StringBuilder res = new StringBuilder();
        while ((c = reader.read()) != -1) {
            if (escape) {
                res.append((char)c);
                escape = false;
                continue;
            }
            if (c == 92) {
                escape = true;
                continue;
            }
            if (c == 59) break;
            res.append((char)c);
        }
        if (res.length() > 0) {
            return Optional.of(res.toString());
        }
        return Optional.empty();
    }
}

