/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.importer.util;

import com.google.common.base.Strings;
import java.util.ArrayList;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.MonthUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONEntryParser {
    private static final Log LOGGER = LogFactory.getLog(JSONEntryParser.class);

    public BibEntry parseBibJSONtoBibtex(JSONObject bibJsonEntry, Character keywordSeparator) {
        String[] singleFieldStrings = new String[]{"year", "title", "abstract", "month"};
        String[] journalSingleFieldStrings = new String[]{"publisher", "number", "volume"};
        BibEntry entry = new BibEntry();
        entry.setType("article");
        if (bibJsonEntry.has("author")) {
            String[] authors = bibJsonEntry.getJSONArray("author");
            ArrayList<String> authorList = new ArrayList<String>();
            for (int i = 0; i < authors.length(); ++i) {
                if (authors.getJSONObject(i).has("name")) {
                    authorList.add(authors.getJSONObject(i).getString("name"));
                    continue;
                }
                LOGGER.info("Empty author name.");
            }
            entry.setField("author", String.join((CharSequence)" and ", authorList));
        } else {
            LOGGER.info("No author found.");
        }
        for (String field : singleFieldStrings) {
            if (!bibJsonEntry.has(field)) continue;
            entry.setField(field, bibJsonEntry.getString(field));
        }
        if (bibJsonEntry.has("start_page")) {
            if (bibJsonEntry.has("end_page")) {
                entry.setField("pages", bibJsonEntry.getString("start_page") + "--" + bibJsonEntry.getString("end_page"));
            } else {
                entry.setField("pages", bibJsonEntry.getString("start_page"));
            }
        }
        if (bibJsonEntry.has("journal")) {
            JSONObject journal = bibJsonEntry.getJSONObject("journal");
            if (journal.has("title")) {
                entry.setField("journal", journal.getString("title"));
            } else {
                LOGGER.info("No journal title found.");
            }
            for (String field : journalSingleFieldStrings) {
                if (!journal.has(field)) continue;
                entry.setField(field, journal.getString(field));
            }
        } else {
            LOGGER.info("No journal information found.");
        }
        if (bibJsonEntry.has("keywords")) {
            JSONArray keywords = bibJsonEntry.getJSONArray("keywords");
            for (int i = 0; i < keywords.length(); ++i) {
                if (keywords.isNull(i)) continue;
                entry.addKeyword(keywords.getString(i), keywordSeparator);
            }
        }
        if (bibJsonEntry.has("identifier")) {
            JSONArray identifiers = bibJsonEntry.getJSONArray("identifier");
            for (int i = 0; i < identifiers.length(); ++i) {
                String type = identifiers.getJSONObject(i).getString("type");
                if ("doi".equals(type)) {
                    entry.setField("doi", identifiers.getJSONObject(i).getString("id"));
                    continue;
                }
                if ("pissn".equals(type)) {
                    entry.setField("issn", identifiers.getJSONObject(i).getString("id"));
                    continue;
                }
                if (!"eissn".equals(type)) continue;
                entry.setField("issn", identifiers.getJSONObject(i).getString("id"));
            }
        }
        if (bibJsonEntry.has("link")) {
            JSONArray links = bibJsonEntry.getJSONArray("link");
            for (int i = 0; i < links.length(); ++i) {
                String type;
                if (!links.getJSONObject(i).has("type") || !"fulltext".equals(type = links.getJSONObject(i).getString("type")) || !links.getJSONObject(i).has("url")) continue;
                entry.setField("url", links.getJSONObject(i).getString("url"));
            }
        }
        return entry;
    }

    public static BibEntry parseSpringerJSONtoBibtex(JSONObject springerJsonEntry) {
        String nametype;
        String[] singleFieldStrings = new String[]{"issn", "volume", "abstract", "doi", "title", "number", "publisher"};
        BibEntry entry = new BibEntry();
        String isbn = springerJsonEntry.optString("isbn");
        if (Strings.isNullOrEmpty(isbn)) {
            entry.setType("article");
            nametype = "journal";
        } else {
            entry.setType("incollection");
            nametype = "booktitle";
            entry.setField("isbn", isbn);
        }
        if (springerJsonEntry.has("creators")) {
            String[] authors = springerJsonEntry.getJSONArray("creators");
            ArrayList<String> authorList = new ArrayList<String>();
            for (int i = 0; i < authors.length(); ++i) {
                if (authors.getJSONObject(i).has("creator")) {
                    authorList.add(authors.getJSONObject(i).getString("creator"));
                    continue;
                }
                LOGGER.info("Empty author name.");
            }
            entry.setField("author", String.join((CharSequence)" and ", authorList));
        } else {
            LOGGER.info("No author found.");
        }
        for (String field : singleFieldStrings) {
            String text;
            if (!springerJsonEntry.has(field) || (text = springerJsonEntry.getString(field)).isEmpty()) continue;
            entry.setField(field, text);
        }
        if (springerJsonEntry.has("startingPage") && !springerJsonEntry.getString("startingPage").isEmpty()) {
            if (springerJsonEntry.has("endPage") && !springerJsonEntry.getString("endPage").isEmpty()) {
                entry.setField("pages", springerJsonEntry.getString("startingPage") + "--" + springerJsonEntry.getString("endPage"));
            } else {
                entry.setField("pages", springerJsonEntry.getString("startingPage"));
            }
        }
        if (springerJsonEntry.has("publicationName")) {
            entry.setField(nametype, springerJsonEntry.getString("publicationName"));
        }
        if (springerJsonEntry.has("url")) {
            JSONArray urlarray = springerJsonEntry.optJSONArray("url");
            if (urlarray == null) {
                entry.setField("url", springerJsonEntry.optString("url"));
            } else {
                entry.setField("url", urlarray.getJSONObject(0).optString("value"));
            }
        }
        if (springerJsonEntry.has("publicationDate")) {
            String date = springerJsonEntry.getString("publicationDate");
            entry.setField("date", date);
            String[] dateparts = date.split("-");
            entry.setField("year", dateparts[0]);
            entry.setField("month", MonthUtil.getMonthByNumber((int)Integer.parseInt((String)dateparts[1])).bibtexFormat);
        }
        entry.getField("abstract").ifPresent(abstractContents -> {
            if (abstractContents.startsWith("Abstract")) {
                entry.setField("abstract", abstractContents.substring(8));
            }
        });
        return entry;
    }
}

