/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.importer.util;

import java.util.ArrayList;
import java.util.List;
import net.sf.jabref.logic.importer.ImportFormatPreferences;
import net.sf.jabref.logic.importer.fileformat.BibtexParser;
import net.sf.jabref.model.entry.BibEntry;

public class DBLPHelper {
    private final DBLPQueryCleaner cleaner = new DBLPQueryCleaner();
    private static final String START_PATTERN = "<pre class=\"verbatim select-on-click\">";
    private static final String END_PATTERN = "</pre>";
    private final ImportFormatPreferences importFormatPreferences;

    public DBLPHelper(ImportFormatPreferences importFormatPreferences) {
        this.importFormatPreferences = importFormatPreferences;
    }

    public String cleanDBLPQuery(String query) {
        return this.cleaner.cleanQuery(query);
    }

    public List<BibEntry> getBibTexFromPage(String page) {
        ArrayList<BibEntry> bibtexList = new ArrayList<BibEntry>();
        String tmpStr = page;
        int startIdx = tmpStr.indexOf(START_PATTERN);
        int endIdx = tmpStr.indexOf(END_PATTERN);
        String entry1 = tmpStr.substring(startIdx + START_PATTERN.length(), endIdx);
        entry1 = this.cleanEntry(entry1);
        BibtexParser.singleFromString(entry1, this.importFormatPreferences).ifPresent(bibtexList::add);
        tmpStr = tmpStr.substring(endIdx + END_PATTERN.length(), tmpStr.length());
        startIdx = tmpStr.indexOf(START_PATTERN);
        if (startIdx != -1) {
            endIdx = tmpStr.indexOf(END_PATTERN);
            String entry2 = tmpStr.substring(startIdx + START_PATTERN.length(), endIdx);
            entry2 = this.cleanEntry(entry2);
            BibtexParser.singleFromString(entry2, this.importFormatPreferences).ifPresent(bibtexList::add);
        }
        return bibtexList;
    }

    private String cleanEntry(String bibEntry) {
        return bibEntry.replaceFirst("<a href=\".*\">DBLP</a>", "DBLP");
    }

    static class DBLPQueryCleaner {
        DBLPQueryCleaner() {
        }

        public String cleanQuery(String query) {
            String cleaned = query;
            cleaned = cleaned.replace("-", " ").replace(" ", "%20").replace(":", "").toLowerCase();
            return cleaned;
        }
    }
}

