/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.importer.fileformat;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import net.sf.jabref.logic.importer.Importer;
import net.sf.jabref.logic.importer.ParserResult;
import net.sf.jabref.logic.util.FileExtensions;
import net.sf.jabref.logic.util.OS;
import net.sf.jabref.model.entry.AuthorList;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.MonthUtil;

public class RisImporter
extends Importer {
    private static final Pattern RECOGNIZED_FORMAT_PATTERN = Pattern.compile("TY  - .*");

    @Override
    public String getName() {
        return "RIS";
    }

    @Override
    public FileExtensions getExtensions() {
        return FileExtensions.RIS;
    }

    @Override
    public String getDescription() {
        return "Imports a Biblioscape Tag File.";
    }

    @Override
    public boolean isRecognizedFormat(BufferedReader reader) throws IOException {
        return reader.lines().anyMatch(line -> RECOGNIZED_FORMAT_PATTERN.matcher((CharSequence)line).find());
    }

    @Override
    public ParserResult importDatabase(BufferedReader reader) throws IOException {
        String[] entries;
        ArrayList<BibEntry> bibitems = new ArrayList<BibEntry>();
        Optional<String> OptionalLines = reader.lines().reduce((line, nextline) -> line + "\n" + nextline);
        String linesAsString = OptionalLines.isPresent() ? OptionalLines.get() : "";
        for (String entry1 : entries = linesAsString.replace("\u2013", "-").replace("\u2014", "--").replace("\u2015", "--").split("ER  -.*\\n")) {
            String type = "";
            String author = "";
            String editor = "";
            String startPage = "";
            String endPage = "";
            String comment = "";
            HashMap<String, String> fields = new HashMap<String, String>();
            String[] lines = entry1.split("\n");
            for (int j = 0; j < lines.length; ++j) {
                StringBuilder current = new StringBuilder(lines[j]);
                boolean done = false;
                while (!done && j < lines.length - 1) {
                    if (lines[j + 1].length() >= 6 && !"  - ".equals(lines[j + 1].substring(2, 6))) {
                        if (current.length() > 0 && !Character.isWhitespace(current.charAt(current.length() - 1)) && !Character.isWhitespace(lines[j + 1].charAt(0))) {
                            current.append(' ');
                        }
                        current.append(lines[j + 1]);
                        ++j;
                        continue;
                    }
                    done = true;
                }
                String entry = current.toString();
                if (entry.length() < 6) continue;
                String tag = entry.substring(0, 2);
                String value = entry.substring(6).trim();
                if ("TY".equals(tag)) {
                    type = "BOOK".equals(value) ? "book" : ("JOUR".equals(value) || "MGZN".equals(value) ? "article" : ("THES".equals(value) ? "phdthesis" : ("UNPB".equals(value) ? "unpublished" : ("RPRT".equals(value) ? "techreport" : ("CONF".equals(value) ? "inproceedings" : ("CHAP".equals(value) ? "incollection" : ("PAT".equals(value) ? "patent" : "other")))))));
                } else if ("T1".equals(tag) || "TI".equals(tag)) {
                    String oldVal = (String)fields.get("title");
                    if (oldVal == null) {
                        fields.put("title", value);
                    } else if (oldVal.endsWith(":") || oldVal.endsWith(".") || oldVal.endsWith("?")) {
                        fields.put("title", oldVal + " " + value);
                    } else {
                        fields.put("title", oldVal + ": " + value);
                    }
                    fields.put("title", ((String)fields.get("title")).replaceAll("\\s+", " "));
                } else if ("BT".equals(tag)) {
                    fields.put("booktitle", value);
                } else if ("T2".equals(tag) || "JO".equals(tag)) {
                    fields.put("journal", value);
                } else if ("T3".equals(tag)) {
                    fields.put("series", value);
                } else if ("AU".equals(tag) || "A1".equals(tag)) {
                    author = "".equals(author) ? value : author + " and " + value;
                } else if ("A2".equals(tag) || "A3".equals(tag) || "A4".equals(tag)) {
                    editor = editor.isEmpty() ? value : editor + " and " + value;
                } else if ("JA".equals(tag) || "JF".equals(tag)) {
                    if ("inproceedings".equals(type)) {
                        fields.put("booktitle", value);
                    } else {
                        fields.put("journal", value);
                    }
                } else if ("LA".equals(tag)) {
                    fields.put("language", value);
                } else if ("CA".equals(tag)) {
                    fields.put("caption", value);
                } else if ("DB".equals(tag)) {
                    fields.put("database", value);
                } else if ("IS".equals(tag)) {
                    fields.put("number", value);
                } else if ("SP".equals(tag)) {
                    startPage = value;
                } else if ("PB".equals(tag)) {
                    if ("phdthesis".equals(type)) {
                        fields.put("school", value);
                    } else {
                        fields.put("publisher", value);
                    }
                } else if ("AD".equals(tag) || "CY".equals(tag)) {
                    fields.put("address", value);
                } else if ("EP".equals(tag)) {
                    endPage = value;
                    if (!endPage.isEmpty()) {
                        endPage = "--" + endPage;
                    }
                } else if ("ET".equals(tag)) {
                    fields.put("edition", value);
                } else if ("SN".equals(tag)) {
                    fields.put("issn", value);
                } else if ("VL".equals(tag)) {
                    fields.put("volume", value);
                } else if ("N2".equals(tag) || "AB".equals(tag)) {
                    String oldAb = (String)fields.get("abstract");
                    if (oldAb == null) {
                        fields.put("abstract", value);
                    } else {
                        fields.put("abstract", oldAb + OS.NEWLINE + value);
                    }
                } else if ("UR".equals(tag)) {
                    fields.put("url", value);
                } else if (("Y1".equals(tag) || "PY".equals(tag) || "DA".equals(tag)) && value.length() >= 4) {
                    fields.put("year", value.substring(0, 4));
                    String[] parts = value.split("/");
                    if (parts.length > 1 && !parts[1].isEmpty()) {
                        try {
                            int monthNumber = Integer.parseInt(parts[1]);
                            MonthUtil.Month month = MonthUtil.getMonthByNumber(monthNumber);
                            if (month.isValid()) {
                                fields.put("month", month.bibtexFormat);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                } else if ("KW".equals(tag)) {
                    if (fields.containsKey("keywords")) {
                        String kw = (String)fields.get("keywords");
                        fields.put("keywords", kw + ", " + value);
                    } else {
                        fields.put("keywords", value);
                    }
                } else if ("U1".equals(tag) || "U2".equals(tag) || "N1".equals(tag)) {
                    if (!comment.isEmpty()) {
                        comment = comment + " ";
                    }
                    comment = comment + value;
                } else if ("ID".equals(tag)) {
                    fields.put("refid", value);
                } else if ("M3".equals(tag) || "DO".equals(tag)) {
                    this.addDoi(fields, value);
                }
                if (!author.isEmpty()) {
                    author = AuthorList.fixAuthorLastNameFirst(author);
                    fields.put("author", author);
                }
                if (!editor.isEmpty()) {
                    editor = AuthorList.fixAuthorLastNameFirst(editor);
                    fields.put("editor", editor);
                }
                if (!comment.isEmpty()) {
                    fields.put("comment", comment);
                }
                fields.put("pages", startPage + endPage);
            }
            BibEntry b = new BibEntry("__ID", type);
            fields.entrySet().removeIf(key -> key.getValue() == null || ((String)key.getValue()).trim().isEmpty());
            b.setField(fields);
            bibitems.add(b);
        }
        return new ParserResult(bibitems);
    }

    private void addDoi(Map<String, String> hm, String val) {
        String doi = val.toLowerCase(Locale.ENGLISH);
        if (doi.startsWith("doi:")) {
            doi = doi.replaceAll("(?i)doi:", "").trim();
            hm.put("doi", doi);
        }
    }
}

