/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.importer.fileformat;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jabref.logic.importer.Importer;
import net.sf.jabref.logic.importer.ParserResult;
import net.sf.jabref.logic.util.FileExtensions;
import net.sf.jabref.model.entry.AuthorList;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.IdGenerator;

public class OvidImporter
extends Importer {
    private static final Pattern OVID_SOURCE_PATTERN = Pattern.compile("Source ([ \\w&\\-,:]+)\\.[ ]+([0-9]+)\\(([\\w\\-]+)\\):([0-9]+\\-?[0-9]+?)\\,.*([0-9][0-9][0-9][0-9])");
    private static final Pattern OVID_SOURCE_PATTERN_NO_ISSUE = Pattern.compile("Source ([ \\w&\\-,:]+)\\.[ ]+([0-9]+):([0-9]+\\-?[0-9]+?)\\,.*([0-9][0-9][0-9][0-9])");
    private static final Pattern OVID_SOURCE_PATTERN_2 = Pattern.compile("([ \\w&\\-,]+)\\. Vol ([0-9]+)\\(([\\w\\-]+)\\) ([A-Za-z]+) ([0-9][0-9][0-9][0-9]), ([0-9]+\\-?[0-9]+)");
    private static final Pattern INCOLLECTION_PATTERN = Pattern.compile("(.+)\\(([0-9][0-9][0-9][0-9])\\)\\. ([ \\w&\\-,:]+)\\.[ ]+\\(pp. ([0-9]+\\-?[0-9]+?)\\).[A-Za-z0-9, ]+pp\\. ([\\w, ]+): ([\\w, ]+)");
    private static final Pattern BOOK_PATTERN = Pattern.compile("\\(([0-9][0-9][0-9][0-9])\\)\\. [A-Za-z, ]+([0-9]+) pp\\. ([\\w, ]+): ([\\w, ]+)");
    private static final String OVID_PATTERN_STRING = "<[0-9]+>";
    private static final Pattern OVID_PATTERN = Pattern.compile("<[0-9]+>");
    private static final int MAX_ITEMS = 50;

    @Override
    public String getName() {
        return "Ovid";
    }

    @Override
    public FileExtensions getExtensions() {
        return FileExtensions.OVID;
    }

    @Override
    public String getDescription() {
        return "Imports an Ovid file.";
    }

    @Override
    public boolean isRecognizedFormat(BufferedReader reader) throws IOException {
        String str;
        for (int i = 0; (str = reader.readLine()) != null && i < 50; ++i) {
            if (!OVID_PATTERN.matcher(str).find()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ParserResult importDatabase(BufferedReader reader) throws IOException {
        String line;
        ArrayList<BibEntry> bibitems = new ArrayList<BibEntry>();
        StringBuilder sb = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            if (!line.isEmpty() && line.charAt(0) != ' ') {
                sb.append("__NEWFIELD__");
            }
            sb.append(line);
            sb.append('\n');
        }
        String[] items = sb.toString().split(OVID_PATTERN_STRING);
        for (int i = 1; i < items.length; ++i) {
            String[] fields;
            HashMap<String, String> h = new HashMap<String, String>();
            for (String field : fields = items[i].split("__NEWFIELD__")) {
                boolean isAuthor;
                int linebreak = field.indexOf(10);
                String fieldName = field.substring(0, linebreak).trim();
                String content = field.substring(linebreak).trim();
                boolean bl = isAuthor = fieldName.indexOf("Author") == 0 && !fieldName.contains("Author Keywords") && !fieldName.contains("Author e-mail");
                if (!isAuthor && content.endsWith(".")) {
                    content = content.substring(0, content.length() - 1);
                }
                if (isAuthor) {
                    h.put("author", content);
                    continue;
                }
                if (fieldName.startsWith("Title")) {
                    if ((content = content.replaceAll("\\[.+\\]", "").trim()).endsWith(".")) {
                        content = content.substring(0, content.length() - 1);
                    }
                    h.put("title", content);
                    continue;
                }
                if (fieldName.startsWith("Chapter Title")) {
                    h.put("chaptertitle", content);
                    continue;
                }
                if (fieldName.startsWith("Source")) {
                    Matcher matcher = OVID_SOURCE_PATTERN.matcher(content);
                    if (matcher.find()) {
                        h.put("journal", matcher.group(1));
                        h.put("volume", matcher.group(2));
                        h.put("issue", matcher.group(3));
                        h.put("pages", matcher.group(4));
                        h.put("year", matcher.group(5));
                    } else {
                        matcher = OVID_SOURCE_PATTERN_NO_ISSUE.matcher(content);
                        if (matcher.find()) {
                            h.put("journal", matcher.group(1));
                            h.put("volume", matcher.group(2));
                            h.put("pages", matcher.group(3));
                            h.put("year", matcher.group(4));
                        } else {
                            matcher = OVID_SOURCE_PATTERN_2.matcher(content);
                            if (matcher.find()) {
                                h.put("journal", matcher.group(1));
                                h.put("volume", matcher.group(2));
                                h.put("issue", matcher.group(3));
                                h.put("month", matcher.group(4));
                                h.put("year", matcher.group(5));
                                h.put("pages", matcher.group(6));
                            } else {
                                matcher = INCOLLECTION_PATTERN.matcher(content);
                                if (matcher.find()) {
                                    h.put("editor", matcher.group(1).replace(" (Ed)", ""));
                                    h.put("year", matcher.group(2));
                                    h.put("booktitle", matcher.group(3));
                                    h.put("pages", matcher.group(4));
                                    h.put("address", matcher.group(5));
                                    h.put("publisher", matcher.group(6));
                                } else {
                                    matcher = BOOK_PATTERN.matcher(content);
                                    if (matcher.find()) {
                                        h.put("year", matcher.group(1));
                                        h.put("pages", matcher.group(2));
                                        h.put("address", matcher.group(3));
                                        h.put("publisher", matcher.group(4));
                                    }
                                }
                            }
                        }
                    }
                    if (h.get("pages") == null) continue;
                    h.put("pages", ((String)h.get("pages")).replace("-", "--"));
                    continue;
                }
                if ("Abstract".equals(fieldName)) {
                    h.put("abstract", content);
                    continue;
                }
                if ("Publication Type".equals(fieldName)) {
                    if (content.contains("Book")) {
                        h.put("entrytype", "book");
                        continue;
                    }
                    if (content.contains("Journal")) {
                        h.put("entrytype", "article");
                        continue;
                    }
                    if (!content.contains("Conference Paper")) continue;
                    h.put("entrytype", "inproceedings");
                    continue;
                }
                if (fieldName.startsWith("Language")) {
                    h.put("language", content);
                    continue;
                }
                if (fieldName.startsWith("Author Keywords")) {
                    content = content.replace(";", ",").replace("  ", " ");
                    h.put("keywords", content);
                    continue;
                }
                if (fieldName.startsWith("ISSN")) {
                    h.put("issn", content);
                    continue;
                }
                if (!fieldName.startsWith("DOI Number")) continue;
                h.put("doi", content);
            }
            String auth = (String)h.get("author");
            if (auth != null && auth.contains(" [Ed]")) {
                h.remove("author");
                h.put("editor", auth.replace(" [Ed]", ""));
            }
            if ((auth = (String)h.get("author")) != null) {
                h.put("author", OvidImporter.fixNames(auth));
            }
            if ((auth = (String)h.get("editor")) != null) {
                h.put("editor", OvidImporter.fixNames(auth));
            }
            String entryType = h.containsKey("entrytype") ? (String)h.get("entrytype") : "misc";
            h.remove("entrytype");
            if ("book".equals(entryType) && h.containsKey("chaptertitle")) {
                entryType = "incollection";
                h.put("title", (String)h.remove("chaptertitle"));
            }
            BibEntry b = new BibEntry(IdGenerator.next(), entryType);
            b.setField(h);
            bibitems.add(b);
        }
        return new ParserResult(bibitems);
    }

    private static String fixNames(String content) {
        String names;
        if (content.indexOf(59) > 0) {
            names = content.replaceAll("[^\\.A-Za-z,;\\- ]", "").replace(";", " and");
        } else if (content.indexOf("  ") > 0) {
            String[] sNames = content.split("  ");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < sNames.length; ++i) {
                if (i > 0) {
                    sb.append(" and ");
                }
                sb.append(sNames[i].replaceFirst(" ", ", "));
            }
            names = sb.toString();
        } else {
            names = content;
        }
        return AuthorList.fixAuthorLastNameFirst(names);
    }
}

