/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.importer.fileformat;

import com.google.common.base.Joiner;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.jabref.logic.importer.Importer;
import net.sf.jabref.logic.importer.ParseException;
import net.sf.jabref.logic.importer.Parser;
import net.sf.jabref.logic.importer.ParserResult;
import net.sf.jabref.logic.importer.fileformat.medline.Abstract;
import net.sf.jabref.logic.importer.fileformat.medline.AbstractText;
import net.sf.jabref.logic.importer.fileformat.medline.AffiliationInfo;
import net.sf.jabref.logic.importer.fileformat.medline.ArticleId;
import net.sf.jabref.logic.importer.fileformat.medline.ArticleIdList;
import net.sf.jabref.logic.importer.fileformat.medline.ArticleTitle;
import net.sf.jabref.logic.importer.fileformat.medline.Author;
import net.sf.jabref.logic.importer.fileformat.medline.AuthorList;
import net.sf.jabref.logic.importer.fileformat.medline.Book;
import net.sf.jabref.logic.importer.fileformat.medline.BookDocument;
import net.sf.jabref.logic.importer.fileformat.medline.BookTitle;
import net.sf.jabref.logic.importer.fileformat.medline.Chemical;
import net.sf.jabref.logic.importer.fileformat.medline.ContributionDate;
import net.sf.jabref.logic.importer.fileformat.medline.DateCompleted;
import net.sf.jabref.logic.importer.fileformat.medline.DateCreated;
import net.sf.jabref.logic.importer.fileformat.medline.DateRevised;
import net.sf.jabref.logic.importer.fileformat.medline.ELocationID;
import net.sf.jabref.logic.importer.fileformat.medline.GeneSymbolList;
import net.sf.jabref.logic.importer.fileformat.medline.GeneralNote;
import net.sf.jabref.logic.importer.fileformat.medline.ISSN;
import net.sf.jabref.logic.importer.fileformat.medline.Investigator;
import net.sf.jabref.logic.importer.fileformat.medline.InvestigatorList;
import net.sf.jabref.logic.importer.fileformat.medline.Journal;
import net.sf.jabref.logic.importer.fileformat.medline.JournalIssue;
import net.sf.jabref.logic.importer.fileformat.medline.Keyword;
import net.sf.jabref.logic.importer.fileformat.medline.KeywordList;
import net.sf.jabref.logic.importer.fileformat.medline.MedlineCitation;
import net.sf.jabref.logic.importer.fileformat.medline.MedlineJournalInfo;
import net.sf.jabref.logic.importer.fileformat.medline.MeshHeading;
import net.sf.jabref.logic.importer.fileformat.medline.MeshHeadingList;
import net.sf.jabref.logic.importer.fileformat.medline.OtherID;
import net.sf.jabref.logic.importer.fileformat.medline.Pagination;
import net.sf.jabref.logic.importer.fileformat.medline.PersonalNameSubject;
import net.sf.jabref.logic.importer.fileformat.medline.PersonalNameSubjectList;
import net.sf.jabref.logic.importer.fileformat.medline.PubDate;
import net.sf.jabref.logic.importer.fileformat.medline.PublicationType;
import net.sf.jabref.logic.importer.fileformat.medline.Publisher;
import net.sf.jabref.logic.importer.fileformat.medline.PubmedArticle;
import net.sf.jabref.logic.importer.fileformat.medline.PubmedArticleSet;
import net.sf.jabref.logic.importer.fileformat.medline.PubmedBookArticle;
import net.sf.jabref.logic.importer.fileformat.medline.PubmedBookArticleSet;
import net.sf.jabref.logic.importer.fileformat.medline.PubmedBookData;
import net.sf.jabref.logic.importer.fileformat.medline.QualifierName;
import net.sf.jabref.logic.importer.fileformat.medline.Section;
import net.sf.jabref.logic.importer.fileformat.medline.Sections;
import net.sf.jabref.logic.importer.fileformat.medline.Text;
import net.sf.jabref.logic.util.FileExtensions;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.IdGenerator;
import net.sf.jabref.model.strings.StringUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MedlineImporter
extends Importer
implements Parser {
    private static final Log LOGGER = LogFactory.getLog(MedlineImporter.class);
    private static final String KEYWORD_SEPARATOR = "; ";
    private static final Locale ENGLISH = Locale.ENGLISH;

    @Override
    public String getName() {
        return "Medline";
    }

    @Override
    public FileExtensions getExtensions() {
        return FileExtensions.MEDLINE;
    }

    @Override
    public String getId() {
        return "medline";
    }

    @Override
    public String getDescription() {
        return "Importer for the Medline format.";
    }

    @Override
    public boolean isRecognizedFormat(BufferedReader reader) throws IOException {
        String str;
        for (int i = 0; (str = reader.readLine()) != null && i < 50; ++i) {
            if (!str.toLowerCase(ENGLISH).contains("<pubmedarticle>") && !str.toLowerCase(ENGLISH).contains("<pubmedbookarticle>")) continue;
            return true;
        }
        return false;
    }

    @Override
    public ParserResult importDatabase(BufferedReader reader) throws IOException {
        Objects.requireNonNull(reader);
        ArrayList<BibEntry> bibItems = new ArrayList<BibEntry>();
        try {
            JAXBContext context = JAXBContext.newInstance((String)"net.sf.jabref.logic.importer.fileformat.medline");
            XMLInputFactory xmlInputFactory = XMLInputFactory.newFactory();
            XMLStreamReader xmlStreamReader = xmlInputFactory.createXMLStreamReader(reader);
            while (!xmlStreamReader.isStartElement()) {
                xmlStreamReader.next();
            }
            Unmarshaller unmarshaller = context.createUnmarshaller();
            Object unmarshalledObject = unmarshaller.unmarshal(xmlStreamReader);
            if (unmarshalledObject instanceof PubmedArticleSet) {
                PubmedArticleSet articleSet = (PubmedArticleSet)unmarshalledObject;
                for (Object article : articleSet.getPubmedArticleOrPubmedBookArticle()) {
                    Object currentArticle;
                    if (article instanceof PubmedArticle) {
                        currentArticle = (PubmedArticle)article;
                        this.parseArticle((PubmedArticle)currentArticle, bibItems);
                    }
                    if (!(article instanceof PubmedBookArticle)) continue;
                    currentArticle = (PubmedBookArticle)article;
                    this.parseBookArticle((PubmedBookArticle)currentArticle, bibItems);
                }
            } else if (unmarshalledObject instanceof PubmedArticle) {
                PubmedArticle article = (PubmedArticle)unmarshalledObject;
                this.parseArticle(article, bibItems);
            } else if (unmarshalledObject instanceof PubmedBookArticle) {
                PubmedBookArticle currentArticle = (PubmedBookArticle)unmarshalledObject;
                this.parseBookArticle(currentArticle, bibItems);
            } else {
                PubmedBookArticleSet bookArticleSet = (PubmedBookArticleSet)unmarshalledObject;
                for (PubmedBookArticle bookArticle : bookArticleSet.getPubmedBookArticle()) {
                    this.parseBookArticle(bookArticle, bibItems);
                }
            }
        }
        catch (JAXBException | XMLStreamException e) {
            LOGGER.debug("could not parse document", e);
            return ParserResult.fromErrorMessage(e.getLocalizedMessage());
        }
        return new ParserResult(bibItems);
    }

    private void parseBookArticle(PubmedBookArticle currentArticle, List<BibEntry> bibItems) {
        HashMap<String, String> fields = new HashMap<String, String>();
        if (currentArticle.getBookDocument() != null) {
            ArrayList<String> result;
            BookDocument bookDocument = currentArticle.getBookDocument();
            fields.put("pmid", bookDocument.getPMID().getContent());
            if (bookDocument.getDateRevised() != null) {
                DateRevised dateRevised = bookDocument.getDateRevised();
                this.addDateRevised(fields, dateRevised);
            }
            if (bookDocument.getAbstract() != null) {
                Abstract abs = bookDocument.getAbstract();
                this.addAbstract(fields, abs);
            }
            if (bookDocument.getPagination() != null) {
                Pagination pagination = bookDocument.getPagination();
                this.addPagination(fields, pagination);
            }
            if (bookDocument.getSections() != null) {
                result = new ArrayList<String>();
                Sections sections = bookDocument.getSections();
                for (Section section : sections.getSection()) {
                    for (Serializable content : section.getSectionTitle().getContent()) {
                        if (!(content instanceof String)) continue;
                        result.add((String)((Object)content));
                    }
                }
                fields.put("sections", MedlineImporter.join(result, KEYWORD_SEPARATOR));
            }
            if (bookDocument.getKeywordList() != null) {
                this.addKeyWords(fields, bookDocument.getKeywordList());
            }
            if (bookDocument.getContributionDate() != null) {
                this.addContributionDate(fields, bookDocument.getContributionDate());
            }
            if (bookDocument.getPublicationType() != null) {
                result = new ArrayList();
                for (PublicationType type : bookDocument.getPublicationType()) {
                    if (type.getContent() == null) continue;
                    result.add(type.getContent());
                }
                fields.put("pubtype", MedlineImporter.join(result, ", "));
            }
            if (bookDocument.getArticleTitle() != null) {
                ArticleTitle articleTitle = bookDocument.getArticleTitle();
                ArrayList<String> titles = new ArrayList<String>();
                for (Serializable content : articleTitle.getContent()) {
                    if (!(content instanceof String)) continue;
                    titles.add((String)((Object)content));
                }
                fields.put("article", MedlineImporter.join(titles, ", "));
            }
            if (bookDocument.getBook() != null) {
                this.addBookInformation(fields, bookDocument.getBook());
            }
        }
        if (currentArticle.getPubmedBookData() != null) {
            PubmedBookData bookData = currentArticle.getPubmedBookData();
            this.putIfValueNotNull(fields, "pubstatus", bookData.getPublicationStatus());
        }
        BibEntry entry = new BibEntry(IdGenerator.next(), "article");
        entry.setField(fields);
        bibItems.add(entry);
    }

    private void addBookInformation(Map<String, String> fields, Book book) {
        if (book.getPublisher() != null) {
            Publisher publisher = book.getPublisher();
            this.putIfValueNotNull(fields, "publocation", publisher.getPublisherLocation());
            this.putStringFromSerializableList(fields, "publisher", publisher.getPublisherName().getContent());
        }
        if (book.getBookTitle() != null) {
            BookTitle title = book.getBookTitle();
            this.putStringFromSerializableList(fields, "title", title.getContent());
        }
        if (book.getPubDate() != null) {
            this.addPubDate(fields, book.getPubDate());
        }
        if (book.getAuthorList() != null) {
            List<AuthorList> authorLists = book.getAuthorList();
            if (authorLists.size() == 1) {
                for (AuthorList authorList : authorLists) {
                    this.handleAuthors(fields, authorList);
                }
            } else {
                LOGGER.info(String.format("Size of authorlist was %s", authorLists.size()));
            }
        }
        this.putIfValueNotNull(fields, "volume", book.getVolume());
        this.putIfValueNotNull(fields, "edition", book.getEdition());
        this.putIfValueNotNull(fields, "medium", book.getMedium());
        this.putIfValueNotNull(fields, "reportnumber", book.getReportNumber());
        if (book.getELocationID() != null) {
            for (ELocationID id : book.getELocationID()) {
                this.addElocationID(fields, id);
            }
        }
        if (book.getIsbn() != null) {
            fields.put("isbn", MedlineImporter.join(book.getIsbn(), ", "));
        }
    }

    private void putStringFromSerializableList(Map<String, String> fields, String medlineKey, List<Serializable> contentList) {
        StringBuilder result = new StringBuilder();
        for (Serializable content : contentList) {
            if (!(content instanceof String)) continue;
            result.append((String)((Object)content));
        }
        if (result.length() > 0) {
            fields.put(medlineKey, result.toString());
        }
    }

    private void addContributionDate(Map<String, String> fields, ContributionDate contributionDate) {
        if (contributionDate.getDay() != null && contributionDate.getMonth() != null && contributionDate.getYear() != null) {
            String result = this.convertToDateFormat(contributionDate.getYear(), contributionDate.getMonth(), contributionDate.getDay());
            fields.put("contribution", result);
        }
    }

    private String convertToDateFormat(String year, String month, String day) {
        return String.format("%s-%s-%s", year, month, day);
    }

    private void parseArticle(PubmedArticle article, List<BibEntry> bibItems) {
        HashMap<String, String> fields = new HashMap<String, String>();
        if (article.getPubmedData() != null && article.getMedlineCitation().getDateRevised() != null) {
            DateRevised dateRevised = article.getMedlineCitation().getDateRevised();
            this.addDateRevised(fields, dateRevised);
            this.putIfValueNotNull(fields, "pubstatus", article.getPubmedData().getPublicationStatus());
            if (article.getPubmedData().getArticleIdList() != null) {
                ArticleIdList articleIdList = article.getPubmedData().getArticleIdList();
                this.addArticleIdList(fields, articleIdList);
            }
        }
        if (article.getMedlineCitation() != null) {
            MedlineCitation medlineCitation = article.getMedlineCitation();
            fields.put("status", medlineCitation.getStatus());
            DateCreated dateCreated = medlineCitation.getDateCreated();
            fields.put("created", this.convertToDateFormat(dateCreated.getYear(), dateCreated.getMonth(), dateCreated.getDay()));
            fields.put("pubmodel", medlineCitation.getArticle().getPubModel());
            if (medlineCitation.getDateCompleted() != null) {
                DateCompleted dateCompleted = medlineCitation.getDateCompleted();
                fields.put("completed", this.convertToDateFormat(dateCompleted.getYear(), dateCompleted.getMonth(), dateCompleted.getDay()));
            }
            fields.put("pmid", medlineCitation.getPMID().getContent());
            fields.put("owner", medlineCitation.getOwner());
            this.addArticleInformation(fields, medlineCitation.getArticle().getContent());
            MedlineJournalInfo medlineJournalInfo = medlineCitation.getMedlineJournalInfo();
            this.putIfValueNotNull(fields, "country", medlineJournalInfo.getCountry());
            this.putIfValueNotNull(fields, "journal-abbreviation", medlineJournalInfo.getMedlineTA());
            this.putIfValueNotNull(fields, "nlm-id", medlineJournalInfo.getNlmUniqueID());
            this.putIfValueNotNull(fields, "issn-linking", medlineJournalInfo.getISSNLinking());
            if (medlineCitation.getChemicalList() != null && medlineCitation.getChemicalList().getChemical() != null) {
                this.addChemicals(fields, medlineCitation.getChemicalList().getChemical());
            }
            if (medlineCitation.getCitationSubset() != null) {
                fields.put("citation-subset", MedlineImporter.join(medlineCitation.getCitationSubset(), ", "));
            }
            if (medlineCitation.getGeneSymbolList() != null) {
                this.addGeneSymbols(fields, medlineCitation.getGeneSymbolList());
            }
            if (medlineCitation.getMeshHeadingList() != null) {
                this.addMeashHeading(fields, medlineCitation.getMeshHeadingList());
            }
            this.putIfValueNotNull(fields, "references", medlineCitation.getNumberOfReferences());
            if (medlineCitation.getPersonalNameSubjectList() != null) {
                this.addPersonalNames(fields, medlineCitation.getPersonalNameSubjectList());
            }
            if (medlineCitation.getOtherID() != null) {
                this.addOtherId(fields, medlineCitation.getOtherID());
            }
            if (medlineCitation.getKeywordList() != null) {
                this.addKeyWords(fields, medlineCitation.getKeywordList());
            }
            if (medlineCitation.getSpaceFlightMission() != null) {
                fields.put("space-flight-mission", MedlineImporter.join(medlineCitation.getSpaceFlightMission(), ", "));
            }
            if (medlineCitation.getInvestigatorList() != null) {
                this.addInvestigators(fields, medlineCitation.getInvestigatorList());
            }
            if (medlineCitation.getGeneralNote() != null) {
                this.addNotes(fields, medlineCitation.getGeneralNote());
            }
        }
        BibEntry entry = new BibEntry(IdGenerator.next(), "article");
        entry.setField(fields);
        bibItems.add(entry);
    }

    private void addArticleIdList(Map<String, String> fields, ArticleIdList articleIdList) {
        for (ArticleId id : articleIdList.getArticleId()) {
            if (id.getIdType() == null) continue;
            if ("pubmed".equals(id.getIdType())) {
                fields.put("pmid", id.getContent());
                continue;
            }
            fields.put(id.getIdType(), id.getContent());
        }
    }

    private void addNotes(Map<String, String> fields, List<GeneralNote> generalNote) {
        ArrayList<String> notes = new ArrayList<String>();
        for (GeneralNote note : generalNote) {
            if (note == null) continue;
            notes.add(note.getContent());
        }
        fields.put("note", MedlineImporter.join(notes, ", "));
    }

    private void addInvestigators(Map<String, String> fields, InvestigatorList investigatorList) {
        ArrayList<String> investigatorNames = new ArrayList<String>();
        ArrayList<String> affiliationInfos = new ArrayList<String>();
        String name = "";
        if (investigatorList.getInvestigator() != null) {
            List<Investigator> investigators = investigatorList.getInvestigator();
            for (Investigator investigator : investigators) {
                name = investigator.getLastName();
                if (investigator.getForeName() != null) {
                    name = name + ", " + investigator.getForeName();
                }
                investigatorNames.add(name);
                if (investigator.getAffiliationInfo() == null) continue;
                for (AffiliationInfo info : investigator.getAffiliationInfo()) {
                    for (Serializable affiliation : info.getAffiliation().getContent()) {
                        if (!(affiliation instanceof String)) continue;
                        affiliationInfos.add((String)((Object)affiliation));
                    }
                }
                fields.put("affiliation", MedlineImporter.join(affiliationInfos, ", "));
            }
            fields.put("investigator", MedlineImporter.join(investigatorNames, " and "));
        }
    }

    private void addKeyWords(Map<String, String> fields, List<KeywordList> allKeywordLists) {
        ArrayList<String> keywordStrings = new ArrayList<String>();
        for (KeywordList keywordList : allKeywordLists) {
            for (Keyword keyword : keywordList.getKeyword()) {
                for (Serializable content : keyword.getContent()) {
                    if (!(content instanceof String)) continue;
                    keywordStrings.add((String)((Object)content));
                }
            }
        }
        if (fields.get("keywords") == null) {
            fields.put("keywords", MedlineImporter.join(keywordStrings, KEYWORD_SEPARATOR));
        } else if (keywordStrings.size() > 0) {
            String result = MedlineImporter.join(keywordStrings, KEYWORD_SEPARATOR);
            result = fields.get("keywords") + KEYWORD_SEPARATOR + result;
            fields.put("keywords", result);
        }
    }

    private void addOtherId(Map<String, String> fields, List<OtherID> otherID) {
        for (OtherID id : otherID) {
            if (id.getSource() == null || id.getContent() == null) continue;
            fields.put(id.getSource(), id.getContent());
        }
    }

    private void addPersonalNames(Map<String, String> fields, PersonalNameSubjectList personalNameSubjectList) {
        if (fields.get("author") == null) {
            ArrayList<String> personalNames = new ArrayList<String>();
            if (personalNameSubjectList.getPersonalNameSubject() != null) {
                List<PersonalNameSubject> personalNameSubject = personalNameSubjectList.getPersonalNameSubject();
                for (PersonalNameSubject personalName : personalNameSubject) {
                    String name = personalName.getLastName();
                    if (personalName.getForeName() != null) {
                        name = name + ", " + personalName.getForeName().toString();
                    }
                    personalNames.add(name);
                }
                fields.put("author", MedlineImporter.join(personalNames, " and "));
            }
        }
    }

    private void addMeashHeading(Map<String, String> fields, MeshHeadingList meshHeadingList) {
        ArrayList<String> keywords = new ArrayList<String>();
        for (MeshHeading keyword : meshHeadingList.getMeshHeading()) {
            String result = keyword.getDescriptorName().getContent();
            if (keyword.getQualifierName() != null) {
                for (QualifierName qualifier : keyword.getQualifierName()) {
                    result = result + ", " + qualifier.getContent();
                }
            }
            keywords.add(result);
        }
        fields.put("keywords", MedlineImporter.join(keywords, KEYWORD_SEPARATOR));
    }

    private void addGeneSymbols(Map<String, String> fields, GeneSymbolList geneSymbolList) {
        List<String> geneSymbols = geneSymbolList.getGeneSymbol();
        fields.put("gene-symbols", MedlineImporter.join(geneSymbols, ", "));
    }

    private void addChemicals(Map<String, String> fields, List<Chemical> chemicals) {
        ArrayList<String> chemicalNames = new ArrayList<String>();
        for (Chemical chemical : chemicals) {
            if (chemical == null) continue;
            chemicalNames.add(chemical.getNameOfSubstance().getContent());
        }
        fields.put("chemicals", MedlineImporter.join(chemicalNames, ", "));
    }

    private void addArticleInformation(Map<String, String> fields, List<Object> content) {
        for (Object object : content) {
            if (object instanceof Journal) {
                Journal journal = (Journal)object;
                this.putIfValueNotNull(fields, "journal", journal.getTitle());
                ISSN issn = journal.getISSN();
                if (issn != null) {
                    this.putIfValueNotNull(fields, "issn", issn.getContent());
                }
                JournalIssue journalIssue = journal.getJournalIssue();
                this.putIfValueNotNull(fields, "volume", journalIssue.getVolume());
                this.putIfValueNotNull(fields, "issue", journalIssue.getIssue());
                this.addPubDate(fields, journalIssue.getPubDate());
                continue;
            }
            if (object instanceof ArticleTitle) {
                ArticleTitle articleTitle = (ArticleTitle)object;
                fields.put("title", StringUtil.stripBrackets(articleTitle.getContent().toString()));
                continue;
            }
            if (object instanceof Pagination) {
                Pagination pagination = (Pagination)object;
                this.addPagination(fields, pagination);
                continue;
            }
            if (object instanceof ELocationID) {
                ELocationID eLocationID = (ELocationID)object;
                this.addElocationID(fields, eLocationID);
                continue;
            }
            if (object instanceof Abstract) {
                Abstract abs = (Abstract)object;
                this.addAbstract(fields, abs);
                continue;
            }
            if (!(object instanceof AuthorList)) continue;
            AuthorList authors = (AuthorList)object;
            this.handleAuthors(fields, authors);
        }
    }

    private void addElocationID(Map<String, String> fields, ELocationID eLocationID) {
        if ("doi".equals(eLocationID.getEIdType())) {
            fields.put("doi", eLocationID.getContent());
        }
        if ("pii".equals(eLocationID.getEIdType())) {
            fields.put("pii", eLocationID.getContent());
        }
    }

    private void addPubDate(Map<String, String> fields, PubDate pubDate) {
        if (pubDate.getYear() == null) {
            fields.put("year", this.extractYear(pubDate.getMedlineDate()));
        } else {
            fields.put("year", pubDate.getYear());
            if (pubDate.getMonth() != null) {
                fields.put("month", pubDate.getMonth());
            } else if (pubDate.getSeason() != null) {
                fields.put("season", pubDate.getSeason());
            }
        }
    }

    private void addAbstract(Map<String, String> fields, Abstract abs) {
        this.putIfValueNotNull(fields, "copyright", abs.getCopyrightInformation());
        ArrayList<String> abstractText = new ArrayList<String>();
        for (AbstractText text : abs.getAbstractText()) {
            for (Serializable textContent : text.getContent()) {
                if (!(textContent instanceof String)) continue;
                abstractText.add((String)((Object)textContent));
            }
        }
        fields.put("abstract", MedlineImporter.join(abstractText, " "));
    }

    private void addPagination(Map<String, String> fields, Pagination pagination) {
        String startPage = "";
        String endPage = "";
        for (JAXBElement<String> element : pagination.getContent()) {
            if ("MedlinePgn".equals(element.getName().getLocalPart())) {
                this.putIfValueNotNull(fields, "pages", this.fixPageRange((String)element.getValue()));
                continue;
            }
            if ("StartPage".equals(element.getName().getLocalPart())) {
                startPage = (String)element.getValue() + endPage;
                this.putIfValueNotNull(fields, "pages", startPage);
                continue;
            }
            if (!"EndPage".equals(element.getName().getLocalPart())) continue;
            endPage = (String)element.getValue();
            fields.put("pages", this.fixPageRange(startPage + "-" + endPage));
        }
    }

    private String extractYear(String medlineDate) {
        return medlineDate.substring(0, 4);
    }

    private void handleAuthors(Map<String, String> fields, AuthorList authors) {
        ArrayList<String> authorNames = new ArrayList<String>();
        for (Author author : authors.getAuthor()) {
            if (author.getCollectiveName() != null) {
                Text collectiveNames = author.getCollectiveName();
                for (Serializable content : collectiveNames.getContent()) {
                    if (!(content instanceof String)) continue;
                    authorNames.add((String)((Object)content));
                }
                continue;
            }
            String authorName = author.getLastName();
            if (author.getForeName() != null) {
                authorName = authorName + ", " + author.getForeName();
            }
            authorNames.add(authorName);
        }
        fields.put("author", MedlineImporter.join(authorNames, " and "));
    }

    private static String join(List<String> list, String string) {
        return Joiner.on(string).join(list);
    }

    private void addDateRevised(Map<String, String> fields, DateRevised dateRevised) {
        if (dateRevised.getDay() != null && dateRevised.getMonth() != null && dateRevised.getYear() != null) {
            fields.put("revised", this.convertToDateFormat(dateRevised.getYear(), dateRevised.getMonth(), dateRevised.getDay()));
        }
    }

    private void putIfValueNotNull(Map<String, String> fields, String medlineKey, String value) {
        if (value != null) {
            fields.put(medlineKey, value);
        }
    }

    private String fixPageRange(String pageRange) {
        int lengthOfStartPage;
        int minusPos = pageRange.indexOf(45);
        if (minusPos < 0) {
            return pageRange;
        }
        String startPage = pageRange.substring(0, minusPos).trim();
        String endPage = pageRange.substring(minusPos + 1).trim();
        int lengthOfEndPage = endPage.length();
        if (lengthOfEndPage < (lengthOfStartPage = startPage.length())) {
            endPage = startPage.substring(0, lengthOfStartPage - lengthOfEndPage) + endPage;
        }
        return startPage + "--" + endPage;
    }

    @Override
    public List<BibEntry> parseEntries(InputStream inputStream) throws ParseException {
        try {
            return this.importDatabase(new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8))).getDatabase().getEntries();
        }
        catch (IOException e) {
            LOGGER.error(e.getLocalizedMessage(), e);
            return Collections.emptyList();
        }
    }
}

