/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.importer.fileformat;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jabref.logic.formatter.casechanger.TitleCaseFormatter;
import net.sf.jabref.logic.importer.Importer;
import net.sf.jabref.logic.importer.ParserResult;
import net.sf.jabref.logic.util.FileExtensions;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.MonthUtil;

public class IsiImporter
extends Importer {
    private static final Pattern SUB_SUP_PATTERN = Pattern.compile("/(sub|sup)\\s+(.*?)\\s*/");
    private static final Pattern ISI_PATTERN = Pattern.compile("FN ISI Export Format|VR 1.|PY \\d{4}");

    @Override
    public String getName() {
        return "ISI";
    }

    @Override
    public FileExtensions getExtensions() {
        return FileExtensions.ISI;
    }

    @Override
    public String getId() {
        return "isi";
    }

    @Override
    public String getDescription() {
        return "Importer for the ISI Web of Science, INSPEC and Medline format.";
    }

    @Override
    public boolean isRecognizedFormat(BufferedReader reader) throws IOException {
        String str;
        for (int i = 0; (str = reader.readLine()) != null && i < 50; ++i) {
            if (!ISI_PATTERN.matcher(str).find()) continue;
            return true;
        }
        return false;
    }

    public static void processSubSup(Map<String, String> map) {
        String[] subsup;
        for (String aSubsup : subsup = new String[]{"title", "abstract", "review", "notes"}) {
            if (!map.containsKey(aSubsup)) continue;
            Matcher m = SUB_SUP_PATTERN.matcher(map.get(aSubsup));
            StringBuffer sb = new StringBuffer();
            while (m.find()) {
                String group2 = m.group(2);
                if ((group2 = group2.replaceAll("\\$", "\\\\\\\\\\\\\\$")).length() > 1) {
                    group2 = "{" + group2 + "}";
                }
                if ("sub".equals(m.group(1))) {
                    m.appendReplacement(sb, "\\$_" + group2 + "\\$");
                    continue;
                }
                m.appendReplacement(sb, "\\$^" + group2 + "\\$");
            }
            m.appendTail(sb);
            map.put(aSubsup, sb.toString());
        }
    }

    private static void processCapitalization(Map<String, String> map) {
        String[] subsup;
        for (String aSubsup : subsup = new String[]{"title", "journal", "publisher"}) {
            String s;
            if (!map.containsKey(aSubsup) || !(s = map.get(aSubsup)).toUpperCase().equals(s)) continue;
            s = new TitleCaseFormatter().format(s);
            map.put(aSubsup, s);
        }
    }

    @Override
    public ParserResult importDatabase(BufferedReader reader) throws IOException {
        String str;
        Objects.requireNonNull(reader);
        ArrayList<BibEntry> bibitems = new ArrayList<BibEntry>();
        StringBuilder sb = new StringBuilder();
        while ((str = reader.readLine()) != null) {
            if (str.length() < 3) continue;
            if ("PT ".equals(str.substring(0, 3))) {
                sb.append("::").append(str);
                continue;
            }
            String beg = str.substring(0, 3).trim();
            if (beg.length() == 2) {
                sb.append(" ## ");
                sb.append(str);
                continue;
            }
            sb.append("EOLEOL");
            sb.append(str.trim());
        }
        String[] entries = sb.toString().split("::");
        HashMap<String, String> hm = new HashMap<String, String>();
        for (String entry : entries) {
            String[] fields = entry.split(" ## ");
            if (fields.length == 0) {
                fields = entry.split("\n");
            }
            String Type2 = "";
            String PT = "";
            String pages = "";
            hm.clear();
            for (String string : fields) {
                if (string.length() <= 2) continue;
                String beg = string.substring(0, 2);
                String value = string.substring(3);
                if (value.startsWith(" - ")) {
                    value = value.substring(3);
                }
                value = value.trim();
                if ("PT".equals(beg)) {
                    PT = value.startsWith("J") ? "article" : value;
                    Type2 = "article";
                    continue;
                }
                if ("TY".equals(beg)) {
                    if ("JOUR".equals(value)) {
                        Type2 = "article";
                        continue;
                    }
                    if (!"CONF".equals(value)) continue;
                    Type2 = "inproceedings";
                    continue;
                }
                if ("JO".equals(beg)) {
                    hm.put("booktitle", value);
                    continue;
                }
                if ("AU".equals(beg)) {
                    String author = IsiImporter.isiAuthorsConvert(value.replace("EOLEOL", " and "));
                    if (hm.get("author") != null) {
                        author = (String)hm.get("author") + " and " + author;
                    }
                    hm.put("author", author);
                    continue;
                }
                if ("TI".equals(beg)) {
                    hm.put("title", value.replace("EOLEOL", " "));
                    continue;
                }
                if ("SO".equals(beg) || "JA".equals(beg)) {
                    hm.put("journal", value.replace("EOLEOL", " "));
                    continue;
                }
                if ("ID".equals(beg) || "KW".equals(beg)) {
                    value = value.replace("EOLEOL", " ");
                    String existingKeywords = (String)hm.get("keywords");
                    existingKeywords = existingKeywords == null || existingKeywords.contains(value) ? value : existingKeywords + ", " + value;
                    hm.put("keywords", existingKeywords);
                    continue;
                }
                if ("AB".equals(beg)) {
                    hm.put("abstract", value.replace("EOLEOL", " "));
                    continue;
                }
                if ("BP".equals(beg) || "BR".equals(beg) || "SP".equals(beg)) {
                    pages = value;
                    continue;
                }
                if ("EP".equals(beg)) {
                    int detpos = value.indexOf(32);
                    if (detpos != -1 && !value.substring(0, detpos).trim().isEmpty()) {
                        value = value.substring(0, detpos);
                    }
                    pages = pages + "--" + value;
                    continue;
                }
                if ("PS".equals(beg)) {
                    pages = IsiImporter.parsePages(value);
                    continue;
                }
                if ("AR".equals(beg)) {
                    pages = value;
                    continue;
                }
                if ("IS".equals(beg)) {
                    hm.put("number", value);
                    continue;
                }
                if ("PY".equals(beg)) {
                    hm.put("year", value);
                    continue;
                }
                if ("VL".equals(beg)) {
                    hm.put("volume", value);
                    continue;
                }
                if ("PU".equals(beg)) {
                    hm.put("publisher", value);
                    continue;
                }
                if ("DI".equals(beg)) {
                    hm.put("doi", value);
                    continue;
                }
                if ("PD".equals(beg)) {
                    String month = IsiImporter.parseMonth(value);
                    if (month == null) continue;
                    hm.put("month", month);
                    continue;
                }
                if ("DT".equals(beg)) {
                    Type2 = value;
                    if ("Review".equals(Type2)) {
                        Type2 = "article";
                        continue;
                    }
                    if (Type2.startsWith("Article") || Type2.startsWith("Journal") || "article".equals(PT)) {
                        Type2 = "article";
                        continue;
                    }
                    Type2 = "misc";
                    continue;
                }
                if ("CR".equals(beg)) {
                    hm.put("CitedReferences", value.replace("EOLEOL", " ; ").trim());
                    continue;
                }
                if ("ER".equals(beg) || "EF".equals(beg) || "VR".equals(beg) || "FN".equals(beg)) continue;
                hm.put(beg.toLowerCase(), value);
            }
            if (!"".equals(pages)) {
                hm.put("pages", pages);
            }
            if (hm.isEmpty()) continue;
            BibEntry b = new BibEntry("__ID", Type2);
            ArrayList toRemove = new ArrayList();
            for (Map.Entry entry2 : hm.entrySet()) {
                String content = (String)entry2.getValue();
                if (content != null && !content.trim().isEmpty()) continue;
                toRemove.add(entry2.getKey());
            }
            for (Map.Entry entry3 : toRemove) {
                hm.remove(entry3);
            }
            IsiImporter.processSubSup(hm);
            IsiImporter.processCapitalization(hm);
            b.setField(hm);
            bibitems.add(b);
        }
        return new ParserResult(bibitems);
    }

    private static String parsePages(String value) {
        int lastDash = value.lastIndexOf(45);
        return value.substring(0, lastDash) + "--" + value.substring(lastDash + 1);
    }

    public static String parseMonth(String value) {
        String[] parts;
        for (String part1 : parts = value.split("\\s|\\-")) {
            MonthUtil.Month month = MonthUtil.getMonthByShortName(part1.toLowerCase());
            if (!month.isValid()) continue;
            return month.bibtexFormat;
        }
        for (String part : parts) {
            try {
                int number = Integer.parseInt(part);
                MonthUtil.Month month = MonthUtil.getMonthByNumber(number);
                if (!month.isValid()) continue;
                return month.bibtexFormat;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String isiAuthorConvert(String author) {
        String[] s = author.split(",");
        if (s.length != 2) {
            return author;
        }
        StringBuilder sb = new StringBuilder();
        String last = s[0].trim();
        sb.append(last).append(", ");
        String first = s[1].trim();
        String[] firstParts = first.split("\\s+");
        for (int i = 0; i < firstParts.length; ++i) {
            first = firstParts[i];
            if (first.toUpperCase().equals(first)) {
                first = first.replace(".", "");
                for (int j = 0; j < first.length(); ++j) {
                    sb.append(first.charAt(j)).append('.');
                    if (j >= first.length() - 1) continue;
                    sb.append(' ');
                }
            } else {
                sb.append(first);
            }
            if (i >= firstParts.length - 1) continue;
            sb.append(' ');
        }
        return sb.toString();
    }

    private static String[] isiAuthorsConvert(String[] authors) {
        String[] result = new String[authors.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = IsiImporter.isiAuthorConvert(authors[i]);
        }
        return result;
    }

    public static String isiAuthorsConvert(String authors) {
        CharSequence[] s = IsiImporter.isiAuthorsConvert(authors.split(" and |;"));
        return String.join((CharSequence)" and ", s);
    }
}

