/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.importer.fileformat;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;
import net.sf.jabref.logic.importer.Importer;
import net.sf.jabref.logic.importer.ParserResult;
import net.sf.jabref.logic.util.FileExtensions;
import net.sf.jabref.model.entry.AuthorList;
import net.sf.jabref.model.entry.BibEntry;

public class InspecImporter
extends Importer {
    private static final Pattern INSPEC_PATTERN = Pattern.compile("Record.*INSPEC.*");

    @Override
    public String getName() {
        return "INSPEC";
    }

    @Override
    public FileExtensions getExtensions() {
        return FileExtensions.INSPEC;
    }

    @Override
    public String getDescription() {
        return "INSPEC format importer.";
    }

    @Override
    public boolean isRecognizedFormat(BufferedReader reader) throws IOException {
        String str;
        while ((str = reader.readLine()) != null) {
            if (!INSPEC_PATTERN.matcher(str).find()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ParserResult importDatabase(BufferedReader reader) throws IOException {
        String str;
        ArrayList<BibEntry> bibitems = new ArrayList<BibEntry>();
        StringBuilder sb = new StringBuilder();
        while ((str = reader.readLine()) != null) {
            if (str.length() < 2) continue;
            if (str.indexOf("Record") == 0) {
                sb.append("__::__").append(str);
                continue;
            }
            sb.append("__NEWFIELD__").append(str);
        }
        String[] entries = sb.toString().split("__::__");
        String type = "";
        HashMap<String, String> h = new HashMap<String, String>();
        for (String entry : entries) {
            String[] fields;
            if (entry.indexOf("Record") != 0) continue;
            h.clear();
            for (String s : fields = entry.split("__NEWFIELD__")) {
                String f3 = s.substring(0, 2);
                String frest = s.substring(5);
                if ("TI".equals(f3)) {
                    h.put("title", frest);
                    continue;
                }
                if ("PY".equals(f3)) {
                    h.put("year", frest);
                    continue;
                }
                if ("AU".equals(f3)) {
                    h.put("author", AuthorList.fixAuthorLastNameFirst(frest.replace(",-", ", ").replace(";", " and ")));
                    continue;
                }
                if ("AB".equals(f3)) {
                    h.put("abstract", frest);
                    continue;
                }
                if ("ID".equals(f3)) {
                    h.put("keywords", frest);
                    continue;
                }
                if ("SO".equals(f3)) {
                    int m = frest.indexOf(46);
                    if (m < 0) continue;
                    String jr = frest.substring(0, m);
                    h.put("journal", jr.replace("-", " "));
                    frest = frest.substring(m);
                    m = frest.indexOf(59);
                    if (m < 5) continue;
                    String yr = frest.substring(m - 5, m).trim();
                    h.put("year", yr);
                    frest = frest.substring(m);
                    m = frest.indexOf(58);
                    if (m < 0) continue;
                    String pg = frest.substring(m + 1).trim();
                    h.put("pages", pg);
                    String vol = frest.substring(1, m).trim();
                    h.put("volume", vol);
                    continue;
                }
                if (!"RT".equals(f3)) continue;
                type = "Journal-Paper".equals(frest = frest.trim()) ? "article" : ("Conference-Paper".equals(frest) || "Conference-Paper; Journal-Paper".equals(frest) ? "inproceedings" : frest.replace(" ", ""));
            }
            BibEntry b = new BibEntry("__ID", type);
            b.setField(h);
            bibitems.add(b);
        }
        return new ParserResult(bibitems);
    }
}

