/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.importer.fileformat;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Scanner;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.jabref.JabRefGUI;
import net.sf.jabref.logic.bibtexkeypattern.BibtexKeyPatternUtil;
import net.sf.jabref.logic.importer.ImportFormatPreferences;
import net.sf.jabref.logic.importer.Importer;
import net.sf.jabref.logic.importer.ParserResult;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.util.FileExtensions;
import net.sf.jabref.logic.util.OS;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.BibtexEntryTypes;
import net.sf.jabref.model.entry.EntryType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FreeCiteImporter
extends Importer {
    private static final Log LOGGER = LogFactory.getLog(FreeCiteImporter.class);
    private final ImportFormatPreferences importFormatPreferences;

    public FreeCiteImporter(ImportFormatPreferences importFormatPreferences) {
        this.importFormatPreferences = importFormatPreferences;
    }

    @Override
    public boolean isRecognizedFormat(BufferedReader reader) throws IOException {
        Objects.requireNonNull(reader);
        return false;
    }

    @Override
    public ParserResult importDatabase(BufferedReader reader) throws IOException {
        try (Scanner scan = new Scanner(reader);){
            String text = scan.useDelimiter("\\A").next();
            ParserResult parserResult = this.importEntries(text);
            return parserResult;
        }
    }

    public ParserResult importEntries(String text) {
        URLConnection conn;
        String urlencodedCitation = null;
        try {
            urlencodedCitation = URLEncoder.encode(text, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.warn("Unsupported encoding", e);
        }
        try {
            URL url = new URL("http://freecite.library.brown.edu/citations/create");
            conn = url.openConnection();
        }
        catch (MalformedURLException e) {
            LOGGER.warn("Bad URL", e);
            return new ParserResult();
        }
        catch (IOException e) {
            LOGGER.warn("Could not download", e);
            return new ParserResult();
        }
        try {
            conn.setRequestProperty("accept", "text/xml");
            conn.setDoOutput(true);
            OutputStreamWriter writer = new OutputStreamWriter(conn.getOutputStream());
            String data = "citation=" + urlencodedCitation;
            writer.write(data);
            writer.flush();
        }
        catch (IllegalStateException e) {
            LOGGER.warn("Already connected.", e);
        }
        catch (IOException e) {
            LOGGER.warn("Unable to connect to FreeCite online service.", e);
            return ParserResult.fromErrorMessage(Localization.lang("Unable to connect to FreeCite online service.", new String[0]));
        }
        ArrayList<BibEntry> res = new ArrayList<BibEntry>();
        XMLInputFactory factory = XMLInputFactory.newInstance();
        try {
            XMLStreamReader parser = factory.createXMLStreamReader(conn.getInputStream());
            while (parser.hasNext()) {
                if (parser.getEventType() == 1 && "citation".equals(parser.getLocalName())) {
                    parser.nextTag();
                    StringBuilder noteSB = new StringBuilder();
                    BibEntry e = new BibEntry();
                    EntryType type = BibtexEntryTypes.INPROCEEDINGS;
                    while (parser.getEventType() != 2 || !"citation".equals(parser.getLocalName())) {
                        if (parser.getEventType() == 1) {
                            String ln = parser.getLocalName();
                            if ("authors".equals(ln)) {
                                StringBuilder sb = new StringBuilder();
                                parser.nextTag();
                                while (parser.getEventType() == 1) {
                                    assert ("author".equals(parser.getLocalName()));
                                    String author = parser.getElementText();
                                    if (sb.length() == 0) {
                                        sb.append(author);
                                    } else {
                                        sb.append(" and ");
                                        sb.append(author);
                                    }
                                    assert (parser.getEventType() == 2);
                                    assert ("author".equals(parser.getLocalName()));
                                    parser.nextTag();
                                }
                                e.setField("author", sb.toString());
                            } else if ("journal".equals(ln)) {
                                type = BibtexEntryTypes.ARTICLE;
                                e.setField(ln, parser.getElementText());
                            } else if ("tech".equals(ln)) {
                                type = BibtexEntryTypes.TECHREPORT;
                                e.setField("number", parser.getElementText());
                            } else if ("doi".equals(ln) || "institution".equals(ln) || "location".equals(ln) || "number".equals(ln) || "note".equals(ln) || "title".equals(ln) || "pages".equals(ln) || "publisher".equals(ln) || "volume".equals(ln) || "year".equals(ln)) {
                                e.setField(ln, parser.getElementText());
                            } else if ("booktitle".equals(ln)) {
                                String booktitle = parser.getElementText();
                                if (booktitle.startsWith("In ")) {
                                    booktitle = booktitle.substring(3);
                                }
                                e.setField("booktitle", booktitle);
                            } else if (!"raw_string".equals(ln)) {
                                noteSB.append(ln);
                                noteSB.append(':');
                                noteSB.append(parser.getElementText());
                                noteSB.append(OS.NEWLINE);
                            }
                        }
                        parser.next();
                    }
                    if (noteSB.length() > 0) {
                        String note = e.hasField("note") ? e.getField("note").get().concat(OS.NEWLINE).concat(noteSB.toString()) : noteSB.toString();
                        e.setField("note", note);
                    }
                    e.setType(type);
                    BibtexKeyPatternUtil.makeLabel(JabRefGUI.getMainFrame().getCurrentBasePanel().getBibDatabaseContext().getMetaData().getCiteKeyPattern(this.importFormatPreferences.getBibtexKeyPatternPreferences().getKeyPattern()), JabRefGUI.getMainFrame().getCurrentBasePanel().getDatabase(), e, this.importFormatPreferences.getBibtexKeyPatternPreferences());
                    res.add(e);
                }
                parser.next();
            }
            parser.close();
        }
        catch (IOException | XMLStreamException ex) {
            LOGGER.warn("Could not parse", ex);
            return new ParserResult();
        }
        return new ParserResult(res);
    }

    @Override
    public String getName() {
        return "text citations";
    }

    @Override
    public FileExtensions getExtensions() {
        return FileExtensions.FREECITE;
    }

    @Override
    public String getDescription() {
        return "This importer parses text format citations using the online API of FreeCite.";
    }
}

