/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.importer.fileformat;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;
import net.sf.jabref.logic.bibtexkeypattern.BibtexKeyPatternUtil;
import net.sf.jabref.logic.importer.ImportFormatPreferences;
import net.sf.jabref.logic.importer.Importer;
import net.sf.jabref.logic.importer.ParserResult;
import net.sf.jabref.logic.util.FileExtensions;
import net.sf.jabref.model.entry.AuthorList;
import net.sf.jabref.model.entry.BibEntry;

public class EndnoteImporter
extends Importer {
    private static final String ENDOFRECORD = "__EOREOR__";
    private static final Pattern A_PATTERN = Pattern.compile("%A .*");
    private static final Pattern E_PATTERN = Pattern.compile("%E .*");
    private final ImportFormatPreferences preferences;

    public EndnoteImporter(ImportFormatPreferences preferences) {
        this.preferences = preferences;
    }

    @Override
    public String getName() {
        return "Refer/Endnote";
    }

    @Override
    public FileExtensions getExtensions() {
        return FileExtensions.ENDNOTE;
    }

    @Override
    public String getId() {
        return "refer";
    }

    @Override
    public String getDescription() {
        return "Importer for the Refer/Endnote format. Modified to use article number for pages if pages are missing.";
    }

    @Override
    public boolean isRecognizedFormat(BufferedReader reader) throws IOException {
        String str;
        while ((str = reader.readLine()) != null) {
            if (!A_PATTERN.matcher(str).matches() && !E_PATTERN.matcher(str).matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ParserResult importDatabase(BufferedReader reader) throws IOException {
        String str;
        ArrayList<BibEntry> bibitems = new ArrayList<BibEntry>();
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        while ((str = reader.readLine()) != null) {
            if ((str = str.trim()).indexOf("%0") == 0) {
                if (first) {
                    first = false;
                } else {
                    sb.append(ENDOFRECORD);
                }
                sb.append(str);
            } else {
                sb.append(str);
            }
            sb.append('\n');
        }
        String[] entries = sb.toString().split(ENDOFRECORD);
        HashMap<String, String> hm = new HashMap<String, String>();
        for (String entry : entries) {
            String[] fields;
            hm.clear();
            String author = "";
            String type = "misc";
            String editor = "";
            String artnum = "";
            boolean isEditedBook = false;
            for (String field : fields = entry.trim().substring(1).split("\n%")) {
                if (field.length() < 3) continue;
                String prefix = field.substring(0, 1);
                String val = field.substring(2);
                if ("A".equals(prefix)) {
                    if ("".equals(author)) {
                        author = val;
                        continue;
                    }
                    author = author + " and " + val;
                    continue;
                }
                if ("E".equals(prefix)) {
                    if ("".equals(editor)) {
                        editor = val;
                        continue;
                    }
                    editor = editor + " and " + val;
                    continue;
                }
                if ("T".equals(prefix)) {
                    hm.put("title", val);
                    continue;
                }
                if ("0".equals(prefix)) {
                    if (val.indexOf("Journal") == 0) {
                        type = "article";
                        continue;
                    }
                    if (val.indexOf("Book Section") == 0) {
                        type = "incollection";
                        continue;
                    }
                    if (val.indexOf("Book") == 0) {
                        type = "book";
                        continue;
                    }
                    if (val.indexOf("Edited Book") == 0) {
                        type = "book";
                        isEditedBook = true;
                        continue;
                    }
                    if (val.indexOf("Conference") == 0) {
                        type = "inproceedings";
                        continue;
                    }
                    if (val.indexOf("Report") == 0) {
                        type = "techreport";
                        continue;
                    }
                    if (val.indexOf("Review") == 0) {
                        type = "article";
                        continue;
                    }
                    if (val.indexOf("Thesis") == 0) {
                        type = "phdthesis";
                        continue;
                    }
                    type = "misc";
                    continue;
                }
                if ("7".equals(prefix)) {
                    hm.put("edition", val);
                    continue;
                }
                if ("C".equals(prefix)) {
                    hm.put("address", val);
                    continue;
                }
                if ("D".equals(prefix)) {
                    hm.put("year", val);
                    continue;
                }
                if ("8".equals(prefix)) {
                    hm.put("date", val);
                    continue;
                }
                if ("J".equals(prefix)) {
                    hm.putIfAbsent("journal", val);
                    continue;
                }
                if ("B".equals(prefix)) {
                    if ("article".equals(type)) {
                        hm.put("journal", val);
                        continue;
                    }
                    if ("book".equals(type) || "inbook".equals(type)) {
                        hm.put("series", val);
                        continue;
                    }
                    hm.put("booktitle", val);
                    continue;
                }
                if ("I".equals(prefix)) {
                    if ("phdthesis".equals(type)) {
                        hm.put("school", val);
                        continue;
                    }
                    hm.put("publisher", val);
                    continue;
                }
                if ("P".equals(prefix)) {
                    hm.put("pages", val.replaceAll("([0-9]) *- *([0-9])", "$1--$2"));
                    continue;
                }
                if ("V".equals(prefix)) {
                    hm.put("volume", val);
                    continue;
                }
                if ("N".equals(prefix)) {
                    hm.put("number", val);
                    continue;
                }
                if ("U".equals(prefix)) {
                    hm.put("url", val);
                    continue;
                }
                if ("R".equals(prefix)) {
                    String doi = val;
                    if (doi.startsWith("doi:")) {
                        doi = doi.substring(4);
                    }
                    hm.put("doi", doi);
                    continue;
                }
                if ("O".equals(prefix)) {
                    if (val.startsWith("Artn")) {
                        String[] tokens = val.split("\\s");
                        artnum = tokens[1];
                        continue;
                    }
                    hm.put("note", val);
                    continue;
                }
                if ("K".equals(prefix)) {
                    hm.put("keywords", val);
                    continue;
                }
                if ("X".equals(prefix)) {
                    hm.put("abstract", val);
                    continue;
                }
                if ("9".equals(prefix)) {
                    if (val.indexOf("Ph.D.") == 0) {
                        type = "phdthesis";
                    }
                    if (val.indexOf("Masters") != 0) continue;
                    type = "mastersthesis";
                    continue;
                }
                if (!"F".equals(prefix)) continue;
                hm.put("bibtexkey", BibtexKeyPatternUtil.checkLegalKey(val, this.preferences.getBibtexKeyPatternPreferences().isEnforceLegalKey()));
            }
            if (isEditedBook && "".equals(editor)) {
                editor = author;
                author = "";
            }
            if (!"".equals(author)) {
                hm.put("author", EndnoteImporter.fixAuthor(author));
            }
            if (!"".equals(editor)) {
                hm.put("editor", EndnoteImporter.fixAuthor(editor));
            }
            if ((hm.get("pages") == null || "-".equals(hm.get("pages"))) && !"".equals(artnum)) {
                hm.put("pages", artnum);
            }
            BibEntry b = new BibEntry("__ID", type);
            b.setField(hm);
            if (b.getFieldNames().isEmpty()) continue;
            bibitems.add(b);
        }
        return new ParserResult(bibitems);
    }

    private static String fixAuthor(String s) {
        int index = s.indexOf(" and ");
        if (index >= 0) {
            return AuthorList.fixAuthorLastNameFirst(s);
        }
        index = s.lastIndexOf(44);
        if (index == s.length() - 1) {
            String mod = s.substring(0, s.length() - 1).replace(", ", " and ");
            return AuthorList.fixAuthorLastNameFirst(mod);
        }
        return AuthorList.fixAuthorLastNameFirst(s);
    }
}

