/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.importer.fileformat;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.sf.jabref.logic.importer.Importer;
import net.sf.jabref.logic.importer.ParserResult;
import net.sf.jabref.logic.util.FileExtensions;

public class CustomImporter
extends Importer {
    private final String className;
    private final Path basePath;
    private Importer importer;

    public CustomImporter(String basePath, String className) throws ClassNotFoundException {
        this.basePath = Paths.get(basePath, new String[0]);
        this.className = className;
        try {
            this.importer = CustomImporter.load(this.basePath.toUri().toURL(), this.className);
        }
        catch (IOException | IllegalAccessException | InstantiationException exception) {
            throw new ClassNotFoundException("", exception);
        }
    }

    private static Importer load(URL basePathURL, String className) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        try (URLClassLoader cl = new URLClassLoader(new URL[]{basePathURL});){
            Class<?> clazz = Class.forName(className, true, cl);
            Importer importer = (Importer)clazz.newInstance();
            return importer;
        }
    }

    public List<String> getAsStringList() {
        return Arrays.asList(this.basePath.toString().replace('\\', '/'), this.className);
    }

    public String getClassName() {
        return this.className;
    }

    public Path getBasePath() {
        return this.basePath;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CustomImporter)) {
            return false;
        }
        CustomImporter otherImporter = (CustomImporter)other;
        return Objects.equals(this.className, otherImporter.className) && Objects.equals(this.basePath, otherImporter.basePath);
    }

    @Override
    public boolean isRecognizedFormat(BufferedReader input) throws IOException {
        return this.importer.isRecognizedFormat(input);
    }

    @Override
    public ParserResult importDatabase(BufferedReader input) throws IOException {
        return this.importer.importDatabase(input);
    }

    @Override
    public String getName() {
        return this.importer.getName();
    }

    @Override
    public FileExtensions getExtensions() {
        return this.importer.getExtensions();
    }

    @Override
    public String getId() {
        return this.importer.getId();
    }

    @Override
    public String getDescription() {
        return this.importer.getDescription();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.className, this.basePath);
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

