/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.importer.fileformat;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import net.sf.jabref.logic.importer.ImportFormatPreferences;
import net.sf.jabref.logic.importer.Importer;
import net.sf.jabref.logic.importer.ParserResult;
import net.sf.jabref.logic.importer.fileformat.BibtexParser;
import net.sf.jabref.logic.util.FileExtensions;

public class BibtexImporter
extends Importer {
    private static final String SIGNATURE = "This file was created with JabRef";
    private final ImportFormatPreferences importFormatPreferences;

    public BibtexImporter(ImportFormatPreferences importFormatPreferences) {
        this.importFormatPreferences = importFormatPreferences;
    }

    @Override
    public boolean isRecognizedFormat(BufferedReader reader) {
        Objects.requireNonNull(reader);
        return true;
    }

    @Override
    public ParserResult importDatabase(Path filePath, Charset defaultEncoding) throws IOException {
        Optional<Charset> suppliedEncoding;
        try (BufferedReader utf8Reader = BibtexImporter.getUTF8Reader(filePath);){
            suppliedEncoding = BibtexImporter.getSuppliedEncoding(utf8Reader);
        }
        if (!suppliedEncoding.isPresent()) {
            var5_4 = null;
            try (BufferedReader utf16Reader = BibtexImporter.getUTF16Reader(filePath);){
                suppliedEncoding = BibtexImporter.getSuppliedEncoding(utf16Reader);
            }
            catch (Throwable throwable) {
                var5_4 = throwable;
                throw throwable;
            }
        }
        if (suppliedEncoding.isPresent()) {
            return super.importDatabase(filePath, suppliedEncoding.get());
        }
        return super.importDatabase(filePath, defaultEncoding);
    }

    @Override
    public ParserResult importDatabase(BufferedReader reader) throws IOException {
        return BibtexParser.parse(reader, this.importFormatPreferences);
    }

    @Override
    public String getName() {
        return "BibTeX";
    }

    @Override
    public FileExtensions getExtensions() {
        return FileExtensions.BIBTEX_DB;
    }

    @Override
    public String getDescription() {
        return "This importer exists only to enable `--importToOpen someEntry.bib`\nIt is NOT intended to import a BIB file. This is done via the option action, which treats the metadata fields.\nThe metadata is not required to be read here, as this class is NOT called at --import.";
    }

    private static Optional<Charset> getSuppliedEncoding(BufferedReader reader) {
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (!(line = line.trim()).startsWith("%")) {
                    return Optional.empty();
                }
                if ((line = line.substring(1).trim()).startsWith(SIGNATURE)) continue;
                if (line.startsWith("Encoding: ")) {
                    Integer atSymbolIndex = line.indexOf(64);
                    String encoding = atSymbolIndex > 0 ? line.substring("Encoding: ".length(), atSymbolIndex) : line.substring("Encoding: ".length());
                    return Optional.of(Charset.forName(encoding));
                }
                return Optional.empty();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Optional.empty();
    }
}

