/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.importer.fileformat;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.XMLGregorianCalendar;
import net.sf.jabref.logic.importer.Importer;
import net.sf.jabref.logic.importer.ParserResult;
import net.sf.jabref.logic.importer.fileformat.bibtexml.Entry;
import net.sf.jabref.logic.importer.fileformat.bibtexml.File;
import net.sf.jabref.logic.importer.fileformat.bibtexml.Inbook;
import net.sf.jabref.logic.importer.fileformat.bibtexml.Incollection;
import net.sf.jabref.logic.util.FileExtensions;
import net.sf.jabref.model.entry.BibEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BibTeXMLImporter
extends Importer {
    private static final Log LOGGER = LogFactory.getLog(BibTeXMLImporter.class);
    private static final Pattern START_PATTERN = Pattern.compile("<(bibtex:)?file .*");
    private static final List<String> IGNORED_METHODS = Arrays.asList("getClass", "getAnnotate", "getContents", "getPrice", "getSize", "getChapter");

    @Override
    public String getName() {
        return "BibTeXML";
    }

    @Override
    public FileExtensions getExtensions() {
        return FileExtensions.BIBTEXML;
    }

    @Override
    public String getDescription() {
        return "Importer for the BibTeXML format.";
    }

    @Override
    public boolean isRecognizedFormat(BufferedReader reader) throws IOException {
        String str;
        while ((str = reader.readLine()) != null) {
            if (!START_PATTERN.matcher(str).find()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ParserResult importDatabase(BufferedReader reader) throws IOException {
        Objects.requireNonNull(reader);
        ArrayList<BibEntry> bibItems = new ArrayList<BibEntry>();
        try {
            JAXBContext context = JAXBContext.newInstance((String)"net.sf.jabref.logic.importer.fileformat.bibtexml");
            Unmarshaller unmarshaller = context.createUnmarshaller();
            File file = (File)unmarshaller.unmarshal((Reader)reader);
            List<Entry> entries = file.getEntry();
            HashMap<String, String> fields = new HashMap<String, String>();
            for (Entry entry : entries) {
                BibEntry bibEntry = new BibEntry();
                if (entry.getArticle() != null) {
                    bibEntry.setType("article");
                    this.parse(entry.getArticle(), fields);
                } else if (entry.getBook() != null) {
                    bibEntry.setType("book");
                    this.parse(entry.getBook(), fields);
                } else if (entry.getBooklet() != null) {
                    bibEntry.setType("booklet");
                    this.parse(entry.getBooklet(), fields);
                } else if (entry.getConference() != null) {
                    bibEntry.setType("conference");
                    this.parse(entry.getConference(), fields);
                } else if (entry.getInbook() != null) {
                    bibEntry.setType("inbook");
                    this.parseInbook(entry.getInbook(), fields);
                } else if (entry.getIncollection() != null) {
                    bibEntry.setType("incollection");
                    Incollection incollection = entry.getIncollection();
                    if (incollection.getChapter() != null) {
                        fields.put("chapter", String.valueOf(incollection.getChapter()));
                    }
                    this.parse(incollection, fields);
                } else if (entry.getInproceedings() != null) {
                    bibEntry.setType("inproceedings");
                    this.parse(entry.getInproceedings(), fields);
                } else if (entry.getManual() != null) {
                    bibEntry.setType("manual");
                    this.parse(entry.getManual(), fields);
                } else if (entry.getMastersthesis() != null) {
                    bibEntry.setType("mastersthesis");
                    this.parse(entry.getMastersthesis(), fields);
                } else if (entry.getMisc() != null) {
                    bibEntry.setType("misc");
                    this.parse(entry.getMisc(), fields);
                } else if (entry.getPhdthesis() != null) {
                    bibEntry.setType("phdthesis");
                    this.parse(entry.getPhdthesis(), fields);
                } else if (entry.getProceedings() != null) {
                    bibEntry.setType("proceedings");
                    this.parse(entry.getProceedings(), fields);
                } else if (entry.getTechreport() != null) {
                    bibEntry.setType("techreport");
                    this.parse(entry.getTechreport(), fields);
                } else if (entry.getUnpublished() != null) {
                    bibEntry.setType("unpublished");
                    this.parse(entry.getUnpublished(), fields);
                }
                if (entry.getId() != null) {
                    bibEntry.setCiteKey(entry.getId());
                }
                bibEntry.setField(fields);
                bibItems.add(bibEntry);
            }
        }
        catch (JAXBException e) {
            LOGGER.error("Error with XML parser configuration", e);
            return ParserResult.fromErrorMessage(e.getLocalizedMessage());
        }
        return new ParserResult(bibItems);
    }

    private <T> void parse(T entryType, Map<String, String> fields) {
        Method[] declaredMethods;
        for (Method method : declaredMethods = entryType.getClass().getDeclaredMethods()) {
            try {
                if (method.getName().equals("getYear")) {
                    this.putYear(fields, (XMLGregorianCalendar)method.invoke(entryType, new Object[0]));
                    continue;
                }
                if (method.getName().equals("getNumber")) {
                    this.putNumber(fields, (BigInteger)method.invoke(entryType, new Object[0]));
                    continue;
                }
                if (this.isMethodToIgnore(method.getName()) || !method.getName().startsWith("get")) continue;
                this.putIfValueNotNull(fields, method.getName().replace("get", ""), (String)method.invoke(entryType, new Object[0]));
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                LOGGER.error("Could not invoke method", e);
            }
        }
    }

    private boolean isMethodToIgnore(String methodName) {
        return IGNORED_METHODS.contains(methodName);
    }

    private void parseInbook(Inbook inbook, Map<String, String> fields) {
        List<JAXBElement<?>> content = inbook.getContent();
        for (JAXBElement<?> element : content) {
            Object value;
            String localName = element.getName().getLocalPart();
            Object elementValue = element.getValue();
            if (elementValue instanceof String) {
                value = (String)elementValue;
                this.putIfValueNotNull(fields, localName, (String)value);
                continue;
            }
            if (elementValue instanceof BigInteger) {
                value = (BigInteger)elementValue;
                if ("number".equals(localName)) {
                    fields.put("number", String.valueOf(value));
                    continue;
                }
                if (!"chapter".equals(localName)) continue;
                fields.put("chapter", String.valueOf(value));
                continue;
            }
            if (elementValue instanceof XMLGregorianCalendar) {
                value = (XMLGregorianCalendar)elementValue;
                if ("year".equals(localName)) {
                    this.putYear(fields, (XMLGregorianCalendar)value);
                    continue;
                }
                LOGGER.info("Unexpected field was found");
                continue;
            }
            LOGGER.info("Unexpected field was found");
        }
    }

    private void putYear(Map<String, String> fields, XMLGregorianCalendar year) {
        if (year != null) {
            fields.put("year", String.valueOf(year));
        }
    }

    private void putNumber(Map<String, String> fields, BigInteger number) {
        if (number != null) {
            fields.put("number", String.valueOf(number));
        }
    }

    private void putIfValueNotNull(Map<String, String> fields, String key, String value) {
        if (value != null) {
            fields.put(key, value);
        }
    }
}

