/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.importer.fetcher;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.jabref.logic.help.HelpFile;
import net.sf.jabref.logic.importer.FetcherException;
import net.sf.jabref.logic.importer.IdBasedParserFetcher;
import net.sf.jabref.logic.importer.Parser;
import net.sf.jabref.logic.importer.ParserResult;
import net.sf.jabref.logic.importer.SearchBasedFetcher;
import net.sf.jabref.logic.importer.fileformat.MedlineImporter;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.entry.BibEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.utils.URIBuilder;

public class MedlineFetcher
implements IdBasedParserFetcher,
SearchBasedFetcher {
    private static final Log LOGGER = LogFactory.getLog(MedlineFetcher.class);
    private static final int NUMBER_TO_FETCH = 50;
    private static final String ID_URL = "https://eutils.ncbi.nlm.nih.gov/entrez/eutils/efetch.fcgi";
    private static final String SEARCH_URL = "https://eutils.ncbi.nlm.nih.gov/entrez/eutils/esearch.fcgi";
    private int numberOfResultsFound;

    private static String replaceCommaWithAND(String query) {
        return query.replaceAll(", ", " AND ").replaceAll(",", " AND ");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> getPubMedIdsFromQuery(String query) throws FetcherException {
        boolean fetchIDs = false;
        boolean firstOccurrenceOfCount = false;
        ArrayList<String> idList = new ArrayList<String>();
        try {
            URL ncbi = this.createSearchUrl(query);
            XMLInputFactory inputFactory = XMLInputFactory.newFactory();
            XMLStreamReader streamReader = inputFactory.createXMLStreamReader(ncbi.openStream());
            block8: while (streamReader.hasNext()) {
                int event = streamReader.getEventType();
                switch (event) {
                    case 1: {
                        if (streamReader.getName().toString().equals("Count")) {
                            firstOccurrenceOfCount = true;
                        }
                        if (!streamReader.getName().toString().equals("IdList")) break;
                        fetchIDs = true;
                        break;
                    }
                    case 4: {
                        if (firstOccurrenceOfCount) {
                            this.numberOfResultsFound = Integer.parseInt(streamReader.getText());
                            firstOccurrenceOfCount = false;
                        }
                        if (!fetchIDs) break;
                        idList.add(streamReader.getText());
                        break;
                    }
                    case 2: {
                        if (streamReader.getName().toString().equals("IdList")) break block8;
                    }
                }
                streamReader.next();
            }
            streamReader.close();
            return idList;
        }
        catch (IOException | URISyntaxException e) {
            throw new FetcherException("Unable to get PubMed IDs", Localization.lang("Unable to get PubMed IDs", new String[0]), e);
        }
        catch (XMLStreamException e) {
            throw new FetcherException("Error while parsing ID list", Localization.lang("Error while parsing ID list", new String[0]), e);
        }
    }

    @Override
    public String getName() {
        return "Medline";
    }

    @Override
    public HelpFile getHelpPage() {
        return HelpFile.FETCHER_MEDLINE;
    }

    @Override
    public URL getURLForID(String identifier) throws URISyntaxException, MalformedURLException, FetcherException {
        URIBuilder uriBuilder = new URIBuilder(ID_URL);
        uriBuilder.addParameter("db", "pubmed");
        uriBuilder.addParameter("retmode", "xml");
        uriBuilder.addParameter("id", identifier);
        return uriBuilder.build().toURL();
    }

    @Override
    public Parser getParser() {
        return new MedlineImporter();
    }

    @Override
    public void doPostCleanup(BibEntry entry) {
        entry.clearField("journal-abbreviation");
        entry.clearField("status");
        entry.clearField("copyright");
    }

    @Override
    public List<BibEntry> performSearch(String query) throws FetcherException {
        LinkedList<BibEntry> entryList = new LinkedList();
        if (query.isEmpty()) {
            return Collections.emptyList();
        }
        String searchTerm = MedlineFetcher.replaceCommaWithAND(query);
        List<String> idList = this.getPubMedIdsFromQuery(searchTerm);
        if (idList.isEmpty()) {
            LOGGER.info("No results found.");
            return Collections.emptyList();
        }
        if (this.numberOfResultsFound > 50) {
            LOGGER.info(this.numberOfResultsFound + " results found. Only 50 relevant results will be fetched by default.");
        }
        entryList = this.fetchMedline(idList);
        return entryList;
    }

    private URL createSearchUrl(String term) throws URISyntaxException, MalformedURLException {
        term = MedlineFetcher.replaceCommaWithAND(term);
        URIBuilder uriBuilder = new URIBuilder(SEARCH_URL);
        uriBuilder.addParameter("db", "pubmed");
        uriBuilder.addParameter("sort", "relevance");
        uriBuilder.addParameter("retmax", String.valueOf(50));
        uriBuilder.addParameter("term", term);
        return uriBuilder.build().toURL();
    }

    private List<BibEntry> fetchMedline(List<String> ids) throws FetcherException {
        try {
            URL fetchURL = this.getURLForID(String.join((CharSequence)",", ids));
            URLConnection data = fetchURL.openConnection();
            ParserResult result = new MedlineImporter().importDatabase(new BufferedReader(new InputStreamReader(data.getInputStream(), StandardCharsets.UTF_8)));
            if (result.hasWarnings()) {
                LOGGER.warn(result.getErrorMessage());
            }
            List<BibEntry> resultList = result.getDatabase().getEntries();
            resultList.forEach(this::doPostCleanup);
            return resultList;
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new FetcherException("Error while generating fetch URL", Localization.lang("Error while generating fetch URL", new String[0]), e);
        }
        catch (IOException e) {
            throw new FetcherException("Error while fetching from Medline", Localization.lang("Error while fetching from %0", "Medline"), e);
        }
    }
}

