/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.importer.fetcher;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jabref.logic.importer.FulltextFetcher;
import net.sf.jabref.logic.net.URLDownload;
import net.sf.jabref.logic.util.DOI;
import net.sf.jabref.model.entry.BibEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IEEE
implements FulltextFetcher {
    private static final Log LOGGER = LogFactory.getLog(IEEE.class);
    private static final Pattern STAMP_PATTERN = Pattern.compile("(/stamp/stamp.jsp\\?t?p?=?&?arnumber=[0-9]+)");
    private static final Pattern PDF_PATTERN = Pattern.compile("\"(http://ieeexplore.ieee.org/ielx[0-9/]+\\.pdf[^\"]+)\"");
    private static final String IEEE_DOI = "10.1109";
    private static final String BASE_URL = "http://ieeexplore.ieee.org";

    @Override
    public Optional<URL> findFullText(BibEntry entry) throws IOException {
        String resolvedDOIPage;
        Matcher matcher;
        Optional doi;
        Matcher matcher2;
        Objects.requireNonNull(entry);
        String stampString = "";
        Optional<String> urlString = entry.getField("url");
        if (urlString.isPresent() && (matcher2 = STAMP_PATTERN.matcher(urlString.get())).find()) {
            stampString = matcher2.group(1);
        }
        if (stampString.isEmpty() && (doi = entry.getField("doi").flatMap(DOI::build)).isPresent() && ((DOI)doi.get()).getDOI().startsWith(IEEE_DOI) && ((DOI)doi.get()).getURI().isPresent() && (matcher = STAMP_PATTERN.matcher(resolvedDOIPage = new URLDownload(((DOI)doi.get()).getURI().get().toURL()).downloadToString(StandardCharsets.UTF_8))).find()) {
            stampString = matcher.group(1);
        }
        if (stampString.isEmpty()) {
            return Optional.empty();
        }
        String framePage = new URLDownload(BASE_URL + stampString).downloadToString(StandardCharsets.UTF_8);
        Matcher matcher3 = PDF_PATTERN.matcher(framePage);
        if (matcher3.find()) {
            LOGGER.debug("Full text document found on IEEE Xplore");
            return Optional.of(new URL(matcher3.group(1)));
        }
        return Optional.empty();
    }
}

