/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.importer.fetcher;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import net.sf.jabref.logic.importer.FulltextFetcher;
import net.sf.jabref.logic.importer.MimeTypeDetector;
import net.sf.jabref.logic.util.DOI;
import net.sf.jabref.model.entry.BibEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class DoiResolution
implements FulltextFetcher {
    private static final Log LOGGER = LogFactory.getLog(DoiResolution.class);

    @Override
    public Optional<URL> findFullText(BibEntry entry) throws IOException {
        String sciLink;
        Objects.requireNonNull(entry);
        Optional pdfLink = Optional.empty();
        Optional doi = entry.getField("doi").flatMap(DOI::build);
        if (doi.isPresent() && !(sciLink = ((DOI)doi.get()).getURIAsASCIIString()).isEmpty()) {
            try {
                Connection connection = Jsoup.connect(sciLink);
                connection.userAgent("Mozilla/5.0 (Windows; U; WindowsNT 5.1; en-US; rv1.8.1.6) Gecko/20070725 Firefox/2.0.0.6");
                connection.referrer("http://www.google.com");
                connection.followRedirects(true);
                connection.ignoreHttpErrors(true);
                connection.timeout(5000);
                Document html = connection.get();
                Elements elements = html.body().select("a[href]");
                ArrayList<Optional<URL>> links = new ArrayList<Optional<URL>>();
                for (Element element : elements) {
                    String href = element.attr("abs:href").toLowerCase(Locale.ENGLISH);
                    String hrefText = element.text().toLowerCase(Locale.ENGLISH);
                    if (!href.contains("pdf") && !hrefText.contains("pdf") || !MimeTypeDetector.isPdfContentType(href)) continue;
                    links.add(Optional.of(new URL(href)));
                }
                if (links.size() == 1) {
                    LOGGER.info("Fulltext PDF found @ " + sciLink);
                    pdfLink = (Optional)links.get(0);
                }
            }
            catch (IOException e) {
                LOGGER.warn("DoiResolution fetcher failed: ", e);
            }
        }
        return pdfLink;
    }
}

