/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.importer.fetcher;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import info.debatty.java.stringsimilarity.Levenshtein;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import net.sf.jabref.logic.formatter.bibtexfields.RemoveBracesFormatter;
import net.sf.jabref.logic.util.DOI;
import net.sf.jabref.model.entry.BibEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CrossRef {
    private static final Log LOGGER = LogFactory.getLog(CrossRef.class);
    private static final RemoveBracesFormatter REMOVE_BRACES_FORMATTER = new RemoveBracesFormatter();
    private static final String API_URL = "http://api.crossref.org";
    private static final Levenshtein METRIC_DISTANCE = new Levenshtein();
    private static final int METRIC_THRESHOLD = 4;

    public static Optional<DOI> findDOI(BibEntry entry) {
        Objects.requireNonNull(entry);
        Optional<DOI> doi = Optional.empty();
        Optional<String> title = entry.getField("title");
        if (!title.isPresent() || title.get().isEmpty()) {
            return doi;
        }
        String query = CrossRef.enhanceQuery(title.get(), entry);
        try {
            HttpResponse<JsonNode> response = Unirest.get("http://api.crossref.org/works").queryString("query", query).queryString("rows", "1").asJson();
            JSONArray items = response.getBody().getObject().getJSONObject("message").getJSONArray("items");
            if (CrossRef.checkValidity(entry, items)) {
                String dataDOI = items.getJSONObject(0).getString("DOI");
                LOGGER.debug("DOI " + dataDOI + " for " + title.get() + " found.");
                return DOI.build(dataDOI);
            }
        }
        catch (UnirestException e) {
            LOGGER.warn("Unable to query CrossRef API: " + e.getMessage(), e);
        }
        return doi;
    }

    private static String enhanceQuery(String query, BibEntry entry) {
        StringBuilder enhancedQuery = new StringBuilder(query);
        entry.getField("author").ifPresent(author -> {
            if (!author.isEmpty()) {
                enhancedQuery.append('+').append((String)author);
            }
        });
        entry.getField("year").ifPresent(year -> {
            if (!year.isEmpty()) {
                enhancedQuery.append('+').append((String)year);
            }
        });
        return enhancedQuery.toString();
    }

    private static boolean checkValidity(BibEntry entry, JSONArray result) {
        String entryTitle = REMOVE_BRACES_FORMATTER.format(entry.getLatexFreeField("title").orElse(""));
        try {
            JSONObject data = result.getJSONObject(0);
            String dataTitle = data.getJSONArray("title").getString(0);
            if (CrossRef.editDistanceIgnoreCase(entryTitle, dataTitle) <= 4.0) {
                return true;
            }
            if (data.getJSONArray("subtitle").length() > 0) {
                String dataWithSubTitle = dataTitle + " " + data.getJSONArray("subtitle").getString(0);
                return CrossRef.editDistanceIgnoreCase(entryTitle, dataWithSubTitle) <= 4.0;
            }
            return false;
        }
        catch (JSONException ex) {
            return false;
        }
    }

    private static double editDistanceIgnoreCase(String a, String b) {
        return METRIC_DISTANCE.distance(a.toLowerCase(Locale.ENGLISH), b.toLowerCase(Locale.ENGLISH));
    }
}

