/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.importer.fetcher;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import net.sf.jabref.logic.importer.ImportFormatPreferences;
import net.sf.jabref.logic.importer.fileformat.BibtexParser;
import net.sf.jabref.logic.net.URLDownload;
import net.sf.jabref.model.entry.BibEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BibsonomyScraper {
    private static final String BIBSONOMY_SCRAPER = "http://scraper.bibsonomy.org/service?url=";
    private static final String BIBSONOMY_SCRAPER_POST = "&format=bibtex";
    private static final Log LOGGER = LogFactory.getLog(BibsonomyScraper.class);

    public static Optional<BibEntry> getEntry(String entryUrl, ImportFormatPreferences importFormatPreferences) {
        try {
            String cleanURL = entryUrl.replace("%", "%25").replace(":", "%3A").replace("/", "%2F").replace("?", "%3F").replace("&", "%26").replace("=", "%3D");
            URL url = new URL(BIBSONOMY_SCRAPER + cleanURL + BIBSONOMY_SCRAPER_POST);
            String bibtex = new URLDownload(url).downloadToString(StandardCharsets.UTF_8);
            return BibtexParser.singleFromString(bibtex, importFormatPreferences);
        }
        catch (IOException ex) {
            LOGGER.warn("Could not download entry", ex);
            return Optional.empty();
        }
        catch (RuntimeException ex) {
            LOGGER.warn("Could not get entry", ex);
            return Optional.empty();
        }
    }
}

