/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.importer.fetcher;

import java.io.IOException;
import java.net.URL;
import java.util.Objects;
import java.util.Optional;
import net.sf.jabref.logic.importer.FulltextFetcher;
import net.sf.jabref.logic.util.DOI;
import net.sf.jabref.model.entry.BibEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class ACS
implements FulltextFetcher {
    private static final Log LOGGER = LogFactory.getLog(ACS.class);
    private static final String SOURCE = "http://pubs.acs.org/doi/abs/%s";

    @Override
    public Optional<URL> findFullText(BibEntry entry) throws IOException {
        String source;
        Document html;
        Element link;
        Objects.requireNonNull(entry);
        Optional<URL> pdfLink = Optional.empty();
        Optional doi = entry.getField("doi").flatMap(DOI::build);
        if (doi.isPresent() && (link = (html = Jsoup.connect(source = String.format(SOURCE, ((DOI)doi.get()).getDOI())).ignoreHttpErrors(true).get()).select(".pdf-high-res a").first()) != null) {
            LOGGER.info("Fulltext PDF found @ ACS.");
            pdfLink = Optional.of(new URL(source.replaceFirst("/abs/", "/pdf/")));
        }
        return pdfLink;
    }
}

