/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.importer;

import java.util.Optional;
import net.sf.jabref.logic.importer.IdBasedFetcher;
import net.sf.jabref.logic.importer.ImportFormatPreferences;
import net.sf.jabref.logic.importer.fetcher.ArXiv;
import net.sf.jabref.logic.importer.fetcher.DoiFetcher;
import net.sf.jabref.logic.importer.fetcher.IsbnFetcher;

public class WebFetchers {
    public static Optional<IdBasedFetcher> getIdBasedFetcherForField(String field, ImportFormatPreferences preferences) {
        IdBasedFetcher fetcher;
        switch (field) {
            case "doi": {
                fetcher = new DoiFetcher(preferences);
                break;
            }
            case "isbn": {
                fetcher = new IsbnFetcher(preferences);
                break;
            }
            case "eprint": {
                fetcher = new ArXiv(preferences);
                break;
            }
            default: {
                return Optional.empty();
            }
        }
        return Optional.of(fetcher);
    }
}

