/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.importer;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import net.sf.jabref.logic.importer.FetcherException;
import net.sf.jabref.logic.importer.ParseException;
import net.sf.jabref.logic.importer.Parser;
import net.sf.jabref.logic.importer.SearchBasedFetcher;
import net.sf.jabref.model.entry.BibEntry;
import org.jsoup.helper.StringUtil;

public interface SearchBasedParserFetcher
extends SearchBasedFetcher {
    public URL getURLForQuery(String var1) throws URISyntaxException, MalformedURLException, FetcherException;

    public Parser getParser();

    default public void doPostCleanup(BibEntry entry) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    default public List<BibEntry> performSearch(String query) throws FetcherException {
        if (StringUtil.isBlank(query)) {
            return Collections.emptyList();
        }
        try (BufferedInputStream stream = new BufferedInputStream(this.getURLForQuery(query).openStream());){
            List<BibEntry> fetchedEntries = this.getParser().parseEntries(stream);
            fetchedEntries.forEach(this::doPostCleanup);
            List<BibEntry> list = fetchedEntries;
            return list;
        }
        catch (URISyntaxException e) {
            throw new FetcherException("Search URI is malformed", e);
        }
        catch (IOException e) {
            throw new FetcherException("An I/O exception occurred", e);
        }
        catch (ParseException e) {
            throw new FetcherException("An internal parser error occurred", e);
        }
    }
}

