/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.importer;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.sf.jabref.model.database.BibDatabase;
import net.sf.jabref.model.database.BibDatabaseContext;
import net.sf.jabref.model.database.BibDatabases;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.EntryType;
import net.sf.jabref.model.metadata.MetaData;

public class ParserResult {
    private static final ParserResult NULL_RESULT = new ParserResult(null, null, null);
    private final BibDatabase base;
    private MetaData metaData;
    private final Map<String, EntryType> entryTypes;
    private BibDatabaseContext bibDatabaseContext;
    private File file;
    private final List<String> warnings = new ArrayList<String>();
    private final List<String> duplicateKeys = new ArrayList<String>();
    private String errorMessage;
    private boolean invalid;
    private boolean toOpenTab;

    public ParserResult() {
        this(Collections.emptyList());
    }

    public ParserResult(Collection<BibEntry> entries) {
        this(BibDatabases.createDatabase(BibDatabases.purgeEmptyEntries(entries)));
    }

    public ParserResult(BibDatabase database) {
        this(database, new MetaData(), new HashMap<String, EntryType>());
    }

    public ParserResult(BibDatabase base, MetaData metaData, Map<String, EntryType> entryTypes) {
        this.base = base;
        this.metaData = metaData;
        this.entryTypes = entryTypes;
        if (Objects.nonNull(base) && Objects.nonNull(metaData)) {
            this.bibDatabaseContext = new BibDatabaseContext(base, metaData, this.file);
        }
    }

    public static ParserResult fromErrorMessage(String message) {
        ParserResult parserResult = new ParserResult();
        parserResult.addWarning(message);
        return parserResult;
    }

    public boolean toOpenTab() {
        return this.toOpenTab;
    }

    public void setToOpenTab(boolean toOpenTab) {
        this.toOpenTab = toOpenTab;
    }

    public BibDatabase getDatabase() {
        return this.base;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(MetaData md) {
        this.metaData = md;
    }

    public Map<String, EntryType> getEntryTypes() {
        return this.entryTypes;
    }

    public Optional<File> getFile() {
        return Optional.ofNullable(this.file);
    }

    public void setFile(File f) {
        this.file = f;
    }

    public void addWarning(String s) {
        if (!this.warnings.contains(s)) {
            this.warnings.add(s);
        }
    }

    public boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }

    public List<String> warnings() {
        return new ArrayList<String>(this.warnings);
    }

    public void addDuplicateKey(String key) {
        if (!this.duplicateKeys.contains(key)) {
            this.duplicateKeys.add(key);
        }
    }

    public boolean hasDuplicateKeys() {
        return !this.duplicateKeys.isEmpty();
    }

    public List<String> getDuplicateKeys() {
        return this.duplicateKeys;
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public void setInvalid(boolean invalid) {
        this.invalid = invalid;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public BibDatabaseContext getDatabaseContext() {
        if (this.bibDatabaseContext == null) {
            this.bibDatabaseContext = new BibDatabaseContext(this.base, this.metaData, this.file);
        }
        return this.bibDatabaseContext;
    }

    public void setDatabaseContext(BibDatabaseContext bibDatabaseContext) {
        Objects.requireNonNull(bibDatabaseContext);
        this.bibDatabaseContext = bibDatabaseContext;
    }

    public boolean hasDatabaseContext() {
        return Objects.nonNull(this.bibDatabaseContext);
    }

    public boolean isNullResult() {
        return this == NULL_RESULT;
    }

    public static ParserResult getNullResult() {
        return NULL_RESULT;
    }
}

