/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.importer;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Objects;
import net.sf.jabref.logic.importer.ParserResult;
import net.sf.jabref.logic.util.FileExtensions;

public abstract class Importer
implements Comparable<Importer> {
    public static final String DEFAULT_BIBTEXENTRY_ID = "__ID";

    public abstract boolean isRecognizedFormat(BufferedReader var1) throws IOException;

    public boolean isRecognizedFormat(Path filePath, Charset encoding) throws IOException {
        try (BufferedReader bufferedReader = Importer.getReader(filePath, encoding);){
            boolean bl = this.isRecognizedFormat(bufferedReader);
            return bl;
        }
    }

    public abstract ParserResult importDatabase(BufferedReader var1) throws IOException;

    public ParserResult importDatabase(Path filePath, Charset encoding) throws IOException {
        try (BufferedReader bufferedReader = Importer.getReader(filePath, encoding);){
            ParserResult parserResult = this.importDatabase(bufferedReader);
            parserResult.getMetaData().setEncoding(encoding);
            parserResult.setFile(filePath.toFile());
            ParserResult parserResult2 = parserResult;
            return parserResult2;
        }
    }

    public static BufferedReader getUTF8Reader(Path filePath) throws IOException {
        return Importer.getReader(filePath, StandardCharsets.UTF_8);
    }

    public static BufferedReader getUTF16Reader(Path filePath) throws IOException {
        return Importer.getReader(filePath, StandardCharsets.UTF_16);
    }

    public static BufferedReader getReader(Path filePath, Charset encoding) throws IOException {
        FileInputStream stream = new FileInputStream(filePath.toFile());
        return new BufferedReader(new InputStreamReader((InputStream)stream, encoding));
    }

    public abstract String getName();

    public abstract FileExtensions getExtensions();

    public String getId() {
        String id = this.getName();
        StringBuilder result = new StringBuilder(id.length());
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (!Character.isLetterOrDigit(c)) continue;
            result.append(Character.toLowerCase(c));
        }
        return result.toString();
    }

    public abstract String getDescription();

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Importer)) {
            return false;
        }
        Importer other = (Importer)obj;
        return Objects.equals(this.getName(), other.getName());
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public int compareTo(Importer o) {
        return this.getName().compareTo(o.getName());
    }
}

