/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.importer;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.jabref.logic.importer.ImportFormatPreferences;
import net.sf.jabref.logic.importer.Importer;
import net.sf.jabref.logic.importer.OpenDatabase;
import net.sf.jabref.logic.importer.ParserResult;
import net.sf.jabref.logic.importer.fileformat.BibTeXMLImporter;
import net.sf.jabref.logic.importer.fileformat.BiblioscapeImporter;
import net.sf.jabref.logic.importer.fileformat.BibtexImporter;
import net.sf.jabref.logic.importer.fileformat.CopacImporter;
import net.sf.jabref.logic.importer.fileformat.CustomImporter;
import net.sf.jabref.logic.importer.fileformat.EndnoteImporter;
import net.sf.jabref.logic.importer.fileformat.FreeCiteImporter;
import net.sf.jabref.logic.importer.fileformat.InspecImporter;
import net.sf.jabref.logic.importer.fileformat.IsiImporter;
import net.sf.jabref.logic.importer.fileformat.MedlineImporter;
import net.sf.jabref.logic.importer.fileformat.MedlinePlainImporter;
import net.sf.jabref.logic.importer.fileformat.ModsImporter;
import net.sf.jabref.logic.importer.fileformat.MsBibImporter;
import net.sf.jabref.logic.importer.fileformat.OvidImporter;
import net.sf.jabref.logic.importer.fileformat.PdfContentImporter;
import net.sf.jabref.logic.importer.fileformat.PdfXmpImporter;
import net.sf.jabref.logic.importer.fileformat.RepecNepImporter;
import net.sf.jabref.logic.importer.fileformat.RisImporter;
import net.sf.jabref.logic.importer.fileformat.SilverPlatterImporter;
import net.sf.jabref.logic.xmp.XMPPreferences;
import net.sf.jabref.model.database.BibDatabases;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.strings.StringUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImportFormatReader {
    private static final Log LOGGER = LogFactory.getLog(ImportFormatReader.class);
    public static final String BIBTEX_FORMAT = "BibTeX";
    private final SortedSet<Importer> formats = new TreeSet<Importer>();
    private ImportFormatPreferences importFormatPreferences;

    public void resetImportFormats(ImportFormatPreferences newImportFormatPreferences, XMPPreferences xmpPreferences) {
        this.importFormatPreferences = newImportFormatPreferences;
        this.formats.clear();
        this.formats.add(new BiblioscapeImporter());
        this.formats.add(new BibtexImporter(this.importFormatPreferences));
        this.formats.add(new BibTeXMLImporter());
        this.formats.add(new CopacImporter());
        this.formats.add(new EndnoteImporter(this.importFormatPreferences));
        this.formats.add(new FreeCiteImporter(this.importFormatPreferences));
        this.formats.add(new InspecImporter());
        this.formats.add(new IsiImporter());
        this.formats.add(new MedlineImporter());
        this.formats.add(new MedlinePlainImporter());
        this.formats.add(new ModsImporter());
        this.formats.add(new MsBibImporter());
        this.formats.add(new OvidImporter());
        this.formats.add(new PdfContentImporter(this.importFormatPreferences));
        this.formats.add(new PdfXmpImporter(xmpPreferences));
        this.formats.add(new RepecNepImporter(this.importFormatPreferences));
        this.formats.add(new RisImporter());
        this.formats.add(new SilverPlatterImporter());
        for (CustomImporter importer : this.importFormatPreferences.getCustomImportList()) {
            this.formats.add(importer);
        }
    }

    private Optional<Importer> getByCliId(String cliId) {
        for (Importer format : this.formats) {
            if (!format.getId().equals(cliId)) continue;
            return Optional.of(format);
        }
        return Optional.empty();
    }

    public ParserResult importFromFile(String format, Path file) throws IOException {
        Optional<Importer> importer = this.getByCliId(format);
        if (!importer.isPresent()) {
            throw new IllegalArgumentException("Unknown import format: " + format);
        }
        return importer.get().importDatabase(file, this.importFormatPreferences.getEncoding());
    }

    public SortedSet<Importer> getImportFormats() {
        return this.formats;
    }

    public String getImportFormatList() {
        StringBuilder sb = new StringBuilder();
        for (Importer imFo : this.formats) {
            int pad = Math.max(0, 14 - imFo.getName().length());
            sb.append("  ");
            sb.append(imFo.getName());
            sb.append(StringUtil.repeatSpaces(pad));
            sb.append(" : ");
            sb.append(imFo.getId());
            sb.append('\n');
        }
        return sb.toString();
    }

    public UnknownFormatImport importUnknownFormat(String filename) {
        return this.importUnknownFormat(Paths.get(filename, new String[0]));
    }

    public UnknownFormatImport importUnknownFormat(Path filePath) {
        Objects.requireNonNull(filePath);
        try {
            ParserResult parserResult = OpenDatabase.loadDatabase(filePath.toFile(), this.importFormatPreferences);
            if (parserResult.getDatabase().hasEntries() || !parserResult.getDatabase().hasNoStrings()) {
                parserResult.setFile(filePath.toFile());
                return new UnknownFormatImport(BIBTEX_FORMAT, parserResult);
            }
        }
        catch (IOException parserResult) {
            // empty catch block
        }
        List<BibEntry> bestResult = null;
        int bestResultCount = 0;
        String bestFormatName = null;
        for (Importer imFo : this.getImportFormats()) {
            try {
                if (!imFo.isRecognizedFormat(filePath, this.importFormatPreferences.getEncoding())) continue;
                ParserResult parserResult = imFo.importDatabase(filePath, this.importFormatPreferences.getEncoding());
                List<BibEntry> entries = parserResult.getDatabase().getEntries();
                BibDatabases.purgeEmptyEntries(entries);
                int entryCount = entries.size();
                if (entryCount <= bestResultCount) continue;
                bestResult = entries;
                bestResultCount = bestResult.size();
                bestFormatName = imFo.getName();
            }
            catch (IOException iOException) {}
        }
        if (bestResult != null) {
            ParserResult parserResult = new ParserResult(bestResult);
            return new UnknownFormatImport(bestFormatName, parserResult);
        }
        return null;
    }

    public static class UnknownFormatImport {
        public final String format;
        public final ParserResult parserResult;

        public UnknownFormatImport(String format, ParserResult parserResult) {
            this.format = format;
            this.parserResult = parserResult;
        }
    }
}

