/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.importer;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import net.sf.jabref.logic.importer.FetcherException;
import net.sf.jabref.logic.importer.IdBasedFetcher;
import net.sf.jabref.logic.importer.ParseException;
import net.sf.jabref.logic.importer.Parser;
import net.sf.jabref.model.entry.BibEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsoup.helper.StringUtil;

public interface IdBasedParserFetcher
extends IdBasedFetcher {
    public static final Log LOGGER = LogFactory.getLog(IdBasedParserFetcher.class);

    public URL getURLForID(String var1) throws URISyntaxException, MalformedURLException, FetcherException;

    public Parser getParser();

    default public void doPostCleanup(BibEntry entry) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    default public Optional<BibEntry> performSearchById(String identifier) throws FetcherException {
        if (StringUtil.isBlank(identifier)) {
            return Optional.empty();
        }
        try (BufferedInputStream stream = new BufferedInputStream(this.getURLForID(identifier).openStream());){
            List<BibEntry> fetchedEntries = this.getParser().parseEntries(stream);
            if (fetchedEntries.isEmpty()) {
                Optional<BibEntry> optional2 = Optional.empty();
                return optional2;
            }
            if (fetchedEntries.size() > 1) {
                LOGGER.info("Fetcher " + this.getName() + "found more than one result for identifier " + identifier + ". We will use the first entry.");
            }
            BibEntry entry = fetchedEntries.get(0);
            this.doPostCleanup(entry);
            Optional<BibEntry> optional = Optional.of(entry);
            return optional;
        }
        catch (URISyntaxException e) {
            throw new FetcherException("Search URI is malformed", e);
        }
        catch (FileNotFoundException e) {
            LOGGER.debug("Id not found");
            return Optional.empty();
        }
        catch (IOException e) {
            throw new FetcherException("An I/O exception occurred", e);
        }
        catch (ParseException e) {
            throw new FetcherException("An internal parser error occurred", e);
        }
    }
}

