/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.logic.importer;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.sf.jabref.logic.importer.FetcherException;
import net.sf.jabref.logic.importer.FulltextFetcher;
import net.sf.jabref.logic.importer.ImportFormatPreferences;
import net.sf.jabref.logic.importer.MimeTypeDetector;
import net.sf.jabref.logic.importer.fetcher.ACS;
import net.sf.jabref.logic.importer.fetcher.ArXiv;
import net.sf.jabref.logic.importer.fetcher.CrossRef;
import net.sf.jabref.logic.importer.fetcher.DoiResolution;
import net.sf.jabref.logic.importer.fetcher.GoogleScholar;
import net.sf.jabref.logic.importer.fetcher.IEEE;
import net.sf.jabref.logic.importer.fetcher.ScienceDirect;
import net.sf.jabref.logic.importer.fetcher.SpringerLink;
import net.sf.jabref.logic.util.DOI;
import net.sf.jabref.model.entry.BibEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FulltextFetchers {
    private static final Log LOGGER = LogFactory.getLog(FulltextFetchers.class);
    private final List<FulltextFetcher> finders = new ArrayList<FulltextFetcher>();

    public FulltextFetchers(ImportFormatPreferences importFormatPreferences) {
        this.finders.add(new DoiResolution());
        this.finders.add(new ScienceDirect());
        this.finders.add(new SpringerLink());
        this.finders.add(new ACS());
        this.finders.add(new ArXiv(importFormatPreferences));
        this.finders.add(new IEEE());
        this.finders.add(new GoogleScholar(importFormatPreferences));
    }

    public FulltextFetchers(List<FulltextFetcher> fetcher) {
        this.finders.addAll(fetcher);
    }

    public Optional<URL> findFullTextPDF(BibEntry entry) {
        BibEntry clonedEntry = (BibEntry)entry.clone();
        Optional<String> doi = clonedEntry.getField("doi");
        if (!doi.isPresent() || !DOI.build(doi.get()).isPresent()) {
            CrossRef.findDOI(clonedEntry).ifPresent(e -> clonedEntry.setField("doi", e.getDOI()));
        }
        for (FulltextFetcher finder : this.finders) {
            try {
                Optional<URL> result = finder.findFullText(clonedEntry);
                if (!result.isPresent() || !MimeTypeDetector.isPdfContentType(result.get().toString())) continue;
                return result;
            }
            catch (IOException | FetcherException e2) {
                LOGGER.debug("Failed to find fulltext PDF at given URL", e2);
            }
        }
        return Optional.empty();
    }
}

